/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.DecisionInstanceGetRequest;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.DecisionInstanceImpl;
import io.camunda.client.protocol.rest.DecisionInstanceGetQueryResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionInstanceGetRequestImpl
implements DecisionInstanceGetRequest {
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String decisionInstanceId;

    public DecisionInstanceGetRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String decisionInstanceId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionInstanceId = decisionInstanceId;
    }

    @Override
    public FinalCommandStep<DecisionInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DecisionInstance> send() {
        HttpCamundaFuture<DecisionInstance> result = new HttpCamundaFuture<DecisionInstance>();
        this.httpClient.get(String.format("/decision-instances/%s", this.decisionInstanceId), this.httpRequestConfig.build(), DecisionInstanceGetQueryResult.class, resp -> new DecisionInstanceImpl((DecisionInstanceGetQueryResult)resp, this.jsonMapper), result);
        return result;
    }
}

