/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.response;

import io.camunda.client.api.response.DocumentMetadata;
import io.camunda.client.impl.util.ParseUtil;
import java.time.OffsetDateTime;
import java.util.Map;

public class DocumentMetadataImpl
implements DocumentMetadata {
    private final io.camunda.client.protocol.rest.DocumentMetadata response;

    public DocumentMetadataImpl(io.camunda.client.protocol.rest.DocumentMetadata response) {
        this.response = response;
    }

    @Override
    public String getContentType() {
        return this.response.getContentType();
    }

    @Override
    public OffsetDateTime getExpiresAt() {
        String expiresAt = this.response.getExpiresAt();
        if (expiresAt == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(expiresAt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse expiresAt date: " + this.response.getExpiresAt(), e);
        }
    }

    @Override
    public Long getSize() {
        return this.response.getSize();
    }

    @Override
    public String getFileName() {
        return this.response.getFileName();
    }

    @Override
    public String getProcessDefinitionId() {
        return this.response.getProcessDefinitionId();
    }

    @Override
    public Long getProcessInstanceKey() {
        return ParseUtil.parseLongOrNull(this.response.getProcessInstanceKey());
    }

    @Override
    public Map<String, Object> getCustomProperties() {
        return this.response.getCustomProperties();
    }
}

