/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.GroupsSearchRequest;
import io.camunda.client.api.search.filter.GroupFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Group;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.GroupSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.GroupFilterRequest;
import io.camunda.client.protocol.rest.GroupSearchQueryRequest;
import io.camunda.client.protocol.rest.GroupSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class GroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<GroupSearchQueryRequest>
implements GroupsSearchRequest {
    private final GroupSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public GroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new GroupSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Group> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Group>> send() {
        HttpCamundaFuture<SearchResponse<Group>> result = new HttpCamundaFuture<SearchResponse<Group>>();
        this.httpClient.post("/groups/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupSearchQueryResult.class, SearchResponseMapper::toGroupsResponse, result);
        return result;
    }

    @Override
    protected GroupSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public GroupsSearchRequest filter(GroupFilter value) {
        this.request.setFilter((GroupFilterRequest)GroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsSearchRequest filter(Consumer<GroupFilter> fn) {
        return this.filter(SearchRequestBuilders.groupFilter(fn));
    }

    @Override
    public GroupsSearchRequest sort(GroupSort value) {
        this.request.setSort(SearchRequestSortMapper.toGroupSearchQuerySortRequest((List)GroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public GroupsSearchRequest sort(Consumer<GroupSort> fn) {
        return this.sort(SearchRequestBuilders.groupSort(fn));
    }

    @Override
    public GroupsSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)GroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }
}

