/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.UsersByGroupSearchRequest;
import io.camunda.client.api.search.filter.UserFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.User;
import io.camunda.client.api.search.sort.UserSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.UserFilterRequest;
import io.camunda.client.protocol.rest.UserSearchQueryRequest;
import io.camunda.client.protocol.rest.UserSearchResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsersByGroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<UserSearchQueryRequest>
implements UsersByGroupSearchRequest {
    private final UserSearchQueryRequest request;
    private final String groupId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public UsersByGroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String groupId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.groupId = groupId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<User> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<User>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<SearchResponse<User>> result = new HttpCamundaFuture<SearchResponse<User>>();
        this.httpClient.post(String.format("/groups/%s/users/search", this.groupId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserSearchResult.class, SearchResponseMapper::toUsersResponse, result);
        return result;
    }

    @Override
    public UsersByGroupSearchRequest filter(UserFilter value) {
        this.request.setFilter((UserFilterRequest)UsersByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersByGroupSearchRequest filter(Consumer<UserFilter> fn) {
        return this.filter(SearchRequestBuilders.userFilter(fn));
    }

    @Override
    public UsersByGroupSearchRequest sort(UserSort value) {
        this.request.setSort(SearchRequestSortMapper.toUserSearchQuerySortRequest((List)UsersByGroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UsersByGroupSearchRequest sort(Consumer<UserSort> fn) {
        return this.sort(SearchRequestBuilders.userSort(fn));
    }

    @Override
    public UsersByGroupSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UsersByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersByGroupSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

