/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.response.BatchOperation;
import io.camunda.client.api.search.response.BatchOperationItems;
import io.camunda.client.api.search.response.DecisionDefinition;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.DecisionRequirements;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Group;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.Mapping;
import io.camunda.client.api.search.response.ProcessDefinition;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.ProcessInstanceCallHierarchyEntryResponse;
import io.camunda.client.api.search.response.ProcessInstanceSequenceFlow;
import io.camunda.client.api.search.response.Role;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.SearchResponsePage;
import io.camunda.client.api.search.response.User;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.response.Variable;
import io.camunda.client.impl.search.response.BatchOperationImpl;
import io.camunda.client.impl.search.response.BatchOperationItemsImpl;
import io.camunda.client.impl.search.response.DecisionDefinitionImpl;
import io.camunda.client.impl.search.response.DecisionInstanceImpl;
import io.camunda.client.impl.search.response.DecisionRequirementsImpl;
import io.camunda.client.impl.search.response.ElementInstanceImpl;
import io.camunda.client.impl.search.response.GroupImpl;
import io.camunda.client.impl.search.response.IncidentImpl;
import io.camunda.client.impl.search.response.MappingImpl;
import io.camunda.client.impl.search.response.ProcessDefinitionImpl;
import io.camunda.client.impl.search.response.ProcessInstanceCallHierarchyEntryResponseImpl;
import io.camunda.client.impl.search.response.ProcessInstanceImpl;
import io.camunda.client.impl.search.response.ProcessInstanceSequenceFlowImpl;
import io.camunda.client.impl.search.response.RoleImpl;
import io.camunda.client.impl.search.response.SearchResponseImpl;
import io.camunda.client.impl.search.response.SearchResponsePageImpl;
import io.camunda.client.impl.search.response.UserImpl;
import io.camunda.client.impl.search.response.UserTaskImpl;
import io.camunda.client.impl.search.response.VariableImpl;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.BatchOperationItemSearchQueryResult;
import io.camunda.client.protocol.rest.BatchOperationResponse;
import io.camunda.client.protocol.rest.BatchOperationSearchQueryResult;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.DecisionInstanceResult;
import io.camunda.client.protocol.rest.DecisionInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.DecisionRequirementsSearchQueryResult;
import io.camunda.client.protocol.rest.ElementInstanceResult;
import io.camunda.client.protocol.rest.ElementInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.GroupResult;
import io.camunda.client.protocol.rest.GroupSearchQueryResult;
import io.camunda.client.protocol.rest.IncidentResult;
import io.camunda.client.protocol.rest.IncidentSearchQueryResult;
import io.camunda.client.protocol.rest.MappingResult;
import io.camunda.client.protocol.rest.MappingSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessDefinitionResult;
import io.camunda.client.protocol.rest.ProcessDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessInstanceCallHierarchyEntry;
import io.camunda.client.protocol.rest.ProcessInstanceResult;
import io.camunda.client.protocol.rest.ProcessInstanceSearchQueryResult;
import io.camunda.client.protocol.rest.ProcessInstanceSequenceFlowsQueryResult;
import io.camunda.client.protocol.rest.RoleResult;
import io.camunda.client.protocol.rest.RoleSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageResponse;
import io.camunda.client.protocol.rest.UserResult;
import io.camunda.client.protocol.rest.UserSearchResult;
import io.camunda.client.protocol.rest.UserTaskSearchQueryResult;
import io.camunda.client.protocol.rest.VariableSearchQueryResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SearchResponseMapper {
    private SearchResponseMapper() {
    }

    public static SearchResponse<ProcessDefinition> toProcessDefinitionSearchResponse(ProcessDefinitionSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ProcessDefinition> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ProcessDefinitionImpl::new);
        return new SearchResponseImpl<ProcessDefinition>(instances, page);
    }

    public static ProcessDefinition toProcessDefinitionGetResponse(ProcessDefinitionResult response) {
        return new ProcessDefinitionImpl(response);
    }

    public static ProcessInstance toProcessInstanceGetResponse(ProcessInstanceResult response) {
        return new ProcessInstanceImpl(response);
    }

    public static SearchResponse<ProcessInstance> toProcessInstanceSearchResponse(ProcessInstanceSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ProcessInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ProcessInstanceImpl::new);
        return new SearchResponseImpl<ProcessInstance>(instances, page);
    }

    public static List<ProcessInstanceSequenceFlow> toProcessInstanceSequenceFlowSearchResponse(ProcessInstanceSequenceFlowsQueryResult response) {
        if (response.getItems() != null) {
            return response.getItems().stream().map(ProcessInstanceSequenceFlowImpl::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static SearchResponse<UserTask> toUserTaskSearchResponse(UserTaskSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<UserTask> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), UserTaskImpl::new);
        return new SearchResponseImpl<UserTask>(instances, page);
    }

    public static SearchResponse<Variable> toVariableSearchResponse(VariableSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Variable> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), VariableImpl::new);
        return new SearchResponseImpl<Variable>(instances, page);
    }

    public static SearchResponse<DecisionDefinition> toDecisionDefinitionSearchResponse(DecisionDefinitionSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionDefinition> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionDefinitionImpl::new);
        return new SearchResponseImpl<DecisionDefinition>(instances, page);
    }

    public static SearchResponse<ElementInstance> toElementInstanceSearchResponse(ElementInstanceSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ElementInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ElementInstanceImpl::new);
        return new SearchResponseImpl<ElementInstance>(instances, page);
    }

    public static ElementInstance toElementInstanceGetResponse(ElementInstanceResult response) {
        return new ElementInstanceImpl(response);
    }

    public static SearchResponse<Incident> toIncidentSearchResponse(IncidentSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Incident> incidents = SearchResponseMapper.toSearchResponseInstances(response.getItems(), IncidentImpl::new);
        return new SearchResponseImpl<Incident>(incidents, page);
    }

    public static Incident toIncidentGetResponse(IncidentResult response) {
        return new IncidentImpl(response);
    }

    private static SearchResponsePage toSearchResponsePage(SearchQueryPageResponse pageResponse) {
        return new SearchResponsePageImpl(pageResponse.getTotalItems(), pageResponse.getFirstSortValues(), pageResponse.getLastSortValues());
    }

    public static SearchResponse<DecisionRequirements> toDecisionRequirementsSearchResponse(DecisionRequirementsSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionRequirements> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionRequirementsImpl::new);
        return new SearchResponseImpl<DecisionRequirements>(instances, page);
    }

    public static SearchResponse<DecisionInstance> toDecisionInstanceSearchResponse(DecisionInstanceSearchQueryResult response, JsonMapper jsonMapper) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), item -> new DecisionInstanceImpl((DecisionInstanceResult)item, jsonMapper));
        return new SearchResponseImpl<DecisionInstance>(instances, page);
    }

    public static BatchOperation toBatchOperationGetResponse(BatchOperationResponse response) {
        return new BatchOperationImpl(response);
    }

    public static BatchOperationItems toBatchOperationItemsGetResponse(BatchOperationItemSearchQueryResult response) {
        return new BatchOperationItemsImpl(response);
    }

    public static Role toRoleResponse(RoleResult response) {
        return new RoleImpl(response.getRoleId(), response.getName(), response.getDescription());
    }

    public static SearchResponse<Role> toRolesResponse(RoleSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Role> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), SearchResponseMapper::toRoleResponse);
        return new SearchResponseImpl<Role>(instances, page);
    }

    public static Group toGroupResponse(GroupResult response) {
        return new GroupImpl(response.getGroupId(), response.getName(), response.getDescription());
    }

    public static User toUserResponse(UserResult response) {
        return new UserImpl(ParseUtil.parseLongOrNull(response.getUserKey()), response.getUsername(), response.getName(), response.getEmail());
    }

    public static Mapping toMappingResponse(MappingResult response) {
        return new MappingImpl(response.getMappingId(), response.getClaimName(), response.getClaimValue(), response.getName());
    }

    public static SearchResponse<Group> toGroupsResponse(GroupSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Group> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), SearchResponseMapper::toGroupResponse);
        return new SearchResponseImpl<Group>(instances, page);
    }

    public static SearchResponse<User> toUsersResponse(UserSearchResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<User> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), SearchResponseMapper::toUserResponse);
        return new SearchResponseImpl<User>(instances, page);
    }

    public static SearchResponse<Mapping> toMappingsResponse(MappingSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Mapping> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), SearchResponseMapper::toMappingResponse);
        return new SearchResponseImpl<Mapping>(instances, page);
    }

    public static SearchResponse<BatchOperation> toBatchOperationsResponse(BatchOperationSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<BatchOperation> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), BatchOperationImpl::new);
        return new SearchResponseImpl<BatchOperation>(instances, page);
    }

    public static SearchResponse<BatchOperationItems.BatchOperationItem> toBatchOperationItemsResponse(BatchOperationItemSearchQueryResult response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<BatchOperationItems.BatchOperationItem> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), BatchOperationItemsImpl.BatchOperationItemImpl::new);
        return new SearchResponseImpl<BatchOperationItems.BatchOperationItem>(instances, page);
    }

    public static List<ProcessInstanceCallHierarchyEntryResponse> toProcessInstanceCallHierarchyEntryResponse(ProcessInstanceCallHierarchyEntry[] entries) {
        return SearchResponseMapper.toSearchResponseInstances(Arrays.asList(entries), ProcessInstanceCallHierarchyEntryResponseImpl::new);
    }

    private static <T, R> List<R> toSearchResponseInstances(List<T> items, Function<T, R> mapper) {
        return Optional.ofNullable(items).map(i -> i.stream().map(mapper).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

