/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.SetVariableRequest;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.response.SetVariablesResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.SetVariablesResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class SetVariablesCommandImpl
implements SetVariablesCommandStep1,
SetVariablesCommandStep1.SetVariablesCommandStep2 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.SetVariablesRequest.Builder grpcRequestObjectBuilder;
    private final JsonMapper jsonMapper;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private boolean useRest;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final SetVariableRequest httpRequestObject = new SetVariableRequest();
    private final long elementInstanceKey;

    public SetVariablesCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long elementInstanceKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc) {
        this.asyncStub = asyncStub;
        this.jsonMapper = jsonMapper;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.grpcRequestObjectBuilder = GatewayOuterClass.SetVariablesRequest.newBuilder();
        this.grpcRequestObjectBuilder.setElementInstanceKey(elementInstanceKey);
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
        this.elementInstanceKey = elementInstanceKey;
        this.requestTimeout(requestTimeout);
    }

    @Override
    public FinalCommandStep<SetVariablesResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SetVariablesResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<SetVariablesResponse> sendRestRequest() {
        HttpZeebeFuture<SetVariablesResponse> result = new HttpZeebeFuture<SetVariablesResponse>();
        this.httpClient.put("/element-instances/" + this.elementInstanceKey + "/variables", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private ZeebeFuture<SetVariablesResponse> sendGrpcRequest() {
        GatewayOuterClass.SetVariablesRequest request = this.grpcRequestObjectBuilder.build();
        RetriableClientFutureImpl<SetVariablesResponse, GatewayOuterClass.SetVariablesResponse> future = new RetriableClientFutureImpl<SetVariablesResponse, GatewayOuterClass.SetVariablesResponse>(SetVariablesResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.SetVariablesResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.SetVariablesResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).setVariables(request, streamObserver);
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 local(boolean local) {
        this.grpcRequestObjectBuilder.setLocal(local);
        this.httpRequestObject.setLocal(local);
        return this;
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(InputStream variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(String variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.validateJson("variables", variables));
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Map<String, Object> variables) {
        return this.variables((Object)variables);
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 variables(Object variables) {
        ArgumentUtil.ensureNotNull("variables", variables);
        return this.setVariables(this.jsonMapper.toJson(variables));
    }

    private SetVariablesCommandStep1.SetVariablesCommandStep2 setVariables(String jsonDocument) {
        this.grpcRequestObjectBuilder.setVariables(jsonDocument);
        if (this.useRest) {
            this.httpRequestObject.setVariables(this.jsonMapper.fromJsonAsMap(jsonDocument));
        }
        return this;
    }

    @Override
    public SetVariablesCommandStep1.SetVariablesCommandStep2 operationReference(long operationReference) {
        this.grpcRequestObjectBuilder.setOperationReference(operationReference);
        this.httpRequestObject.setOperationReference(operationReference);
        return this;
    }

    @Override
    public SetVariablesCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public SetVariablesCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

