/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToTenantCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignRoleToTenantCommandImpl
implements AssignRoleToTenantCommandStep1 {
    private final String tenantId;
    private String roleId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public AssignRoleToTenantCommandImpl(HttpClient httpClient, String tenantId) {
        this.httpClient = httpClient;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToTenantCommandStep1 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToTenantResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<AssignRoleToTenantResponse> result = new HttpCamundaFuture<AssignRoleToTenantResponse>();
        String endpoint = String.format("/tenants/%s/roles/%s", this.tenantId, this.roleId);
        this.httpClient.put(endpoint, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

