/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CorrelateMessageCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.CorrelateMessageResponse;
import io.camunda.client.impl.command.CommandWithVariables;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CorrelateMessageResponseImpl;
import io.camunda.client.protocol.rest.MessageCorrelationRequest;
import io.camunda.client.protocol.rest.MessageCorrelationResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class CorrelateMessageCommandImpl
extends CommandWithVariables<CorrelateMessageCommandImpl>
implements CorrelateMessageCommandStep1,
CorrelateMessageCommandStep1.CorrelateMessageCommandStep2,
CorrelateMessageCommandStep1.CorrelateMessageCommandStep3 {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final MessageCorrelationRequest request = new MessageCorrelationRequest();
    private final RequestConfig.Builder httpRequestConfig;

    public CorrelateMessageCommandImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        super(jsonMapper);
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public CorrelateMessageCommandStep1.CorrelateMessageCommandStep2 messageName(String messageName) {
        this.request.setName(messageName);
        return this;
    }

    @Override
    public CorrelateMessageCommandStep1.CorrelateMessageCommandStep3 tenantId(String tenantId) {
        this.request.setTenantId(tenantId);
        return this;
    }

    @Override
    public CorrelateMessageCommandStep1.CorrelateMessageCommandStep3 correlationKey(String correlationKey) {
        this.request.setCorrelationKey(correlationKey);
        return this;
    }

    @Override
    public CorrelateMessageCommandStep1.CorrelateMessageCommandStep3 withoutCorrelationKey() {
        return this;
    }

    @Override
    public FinalCommandStep<CorrelateMessageResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CorrelateMessageResponse> send() {
        HttpCamundaFuture<CorrelateMessageResponse> result = new HttpCamundaFuture<CorrelateMessageResponse>();
        CorrelateMessageResponseImpl response = new CorrelateMessageResponseImpl(this.jsonMapper);
        this.httpClient.post("/messages/correlation", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), MessageCorrelationResult.class, response::setResponse, result);
        return result;
    }

    @Override
    protected CorrelateMessageCommandImpl setVariablesInternal(String variables) {
        this.request.setVariables(this.jsonMapper.fromJsonAsMap(variables));
        return this;
    }
}

