/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.DeleteRoleCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.DeleteRoleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteRoleCommandImpl
implements DeleteRoleCommandStep1 {
    private final String roleId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DeleteRoleCommandImpl(HttpClient httpClient, String roleId) {
        this.roleId = roleId;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalCommandStep<DeleteRoleResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DeleteRoleResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<DeleteRoleResponse> result = new HttpCamundaFuture<DeleteRoleResponse>();
        this.httpClient.delete("/roles/" + this.roleId, this.httpRequestConfig.build(), result);
        return result;
    }
}

