/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignMappingFromGroupStep1;
import io.camunda.client.api.response.UnassignMappingFromGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignMappingFromGroupCommandImpl
implements UnassignMappingFromGroupStep1 {
    private final String groupId;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String mappingId;

    public UnassignMappingFromGroupCommandImpl(HttpClient httpClient, String groupId) {
        this.groupId = groupId;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignMappingFromGroupStep1 mappingId(String mappingId) {
        this.mappingId = mappingId;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignMappingFromGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignMappingFromGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingId", this.mappingId);
        HttpCamundaFuture<UnassignMappingFromGroupResponse> result = new HttpCamundaFuture<UnassignMappingFromGroupResponse>();
        this.httpClient.delete("/groups/" + this.groupId + "/mapping-rules/" + this.mappingId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

