/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignRoleFromMappingCommandStep1;
import io.camunda.client.api.response.UnassignRoleFromMappingResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignRoleFromMappingCommandImpl
implements UnassignRoleFromMappingCommandStep1,
UnassignRoleFromMappingCommandStep1.UnassignRoleFromMappingCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;
    private String mappingId;

    public UnassignRoleFromMappingCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignRoleFromMappingCommandStep1.UnassignRoleFromMappingCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public UnassignRoleFromMappingCommandStep1.UnassignRoleFromMappingCommandStep2 mappingId(String mappingId) {
        this.mappingId = mappingId;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignRoleFromMappingResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignRoleFromMappingResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingId", this.mappingId);
        HttpCamundaFuture<UnassignRoleFromMappingResponse> result = new HttpCamundaFuture<UnassignRoleFromMappingResponse>();
        this.httpClient.delete("/roles/" + this.roleId + "/mappings/" + this.mappingId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

