/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignRoleFromUserCommandStep1;
import io.camunda.client.api.response.UnassignUserFromRoleResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignRoleFromUserCommandImpl
implements UnassignRoleFromUserCommandStep1,
UnassignRoleFromUserCommandStep1.UnassignRoleFromUserCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;
    private String username;

    public UnassignRoleFromUserCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignRoleFromUserCommandStep1.UnassignRoleFromUserCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public UnassignRoleFromUserCommandStep1.UnassignRoleFromUserCommandStep2 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignUserFromRoleResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignUserFromRoleResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("username", this.username);
        HttpCamundaFuture<UnassignUserFromRoleResponse> result = new HttpCamundaFuture<UnassignUserFromRoleResponse>();
        this.httpClient.delete(String.format("/roles/%s/users/%s", this.roleId, this.username), this.httpRequestConfig.build(), result);
        return result;
    }
}

