/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.fetch.DecisionDefinitionGetRequest;
import io.camunda.client.api.search.response.DecisionDefinition;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.DecisionDefinitionImpl;
import io.camunda.client.protocol.rest.DecisionDefinitionResult;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionDefinitionGetRequestImpl
implements DecisionDefinitionGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long decisionDefinitionKey;

    public DecisionDefinitionGetRequestImpl(HttpClient httpClient, long decisionDefinitionKey) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public DecisionDefinitionGetRequest requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<DecisionDefinition> send() {
        HttpCamundaFuture<DecisionDefinition> result = new HttpCamundaFuture<DecisionDefinition>();
        this.httpClient.get(String.format("/decision-definitions/%d", this.decisionDefinitionKey), this.httpRequestConfig.build(), DecisionDefinitionResult.class, DecisionDefinitionImpl::new, result);
        return result;
    }
}

