/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.filter;

import io.camunda.client.api.search.filter.VariableValueFilter;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.StringFilterProperty;
import io.camunda.client.protocol.rest.VariableValueFilterRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VariableFilterMapper {
    public static List<VariableValueFilterRequest> toVariableValueFilterRequest(List<Consumer<VariableValueFilter>> variableValueFilters) {
        return VariableFilterMapper.toVariableValueFilterRequest(variableValueFilters.stream().map(SearchRequestBuilders::variableValueFilter).map(TypedSearchRequestPropertyProvider::provideSearchRequestProperty));
    }

    public static List<VariableValueFilterRequest> toVariableValueFilterRequest(Map<String, Object> variableValueFilters) {
        return VariableFilterMapper.toVariableValueFilterRequest(variableValueFilters.entrySet().stream().map(entry -> new VariableValueFilterRequest().name((String)entry.getKey()).value(entry.getValue() == null ? new StringFilterProperty() : new StringFilterProperty().$eq(entry.getValue().toString()))));
    }

    static List<VariableValueFilterRequest> toVariableValueFilterRequest(Stream<VariableValueFilterRequest> filterStream) {
        ArrayList violations = new ArrayList();
        List<VariableValueFilterRequest> filters = filterStream.map(filter -> VariableFilterMapper.checkVariableValueNotNull(filter, violations)).collect(Collectors.toList());
        if (!violations.isEmpty()) {
            throw new IllegalArgumentException("Variable value filters contain violations: " + String.join((CharSequence)". ", violations));
        }
        return filters;
    }

    static VariableValueFilterRequest checkVariableValueNotNull(VariableValueFilterRequest filter, List<String> violations) {
        if (filter.getValue() == null || filter.getValue().equals(new StringFilterProperty())) {
            violations.add("Variable value cannot be null for variable '" + filter.getName() + "'");
        }
        return filter;
    }
}

