/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.response;

import io.camunda.client.api.search.enums.AdHocSubProcessActivityResultType;
import io.camunda.client.api.search.response.AdHocSubProcessActivityResponse;
import io.camunda.client.impl.util.EnumUtil;
import io.camunda.client.protocol.rest.AdHocSubProcessActivityResult;
import io.camunda.client.protocol.rest.AdHocSubProcessActivitySearchQueryResult;
import java.util.List;
import java.util.stream.Collectors;

public class AdHocSubProcessActivityResponseImpl
implements AdHocSubProcessActivityResponse {
    private final List<AdHocSubProcessActivityResponse.AdHocSubProcessActivity> items;

    public AdHocSubProcessActivityResponseImpl(AdHocSubProcessActivitySearchQueryResult response) {
        this.items = response.getItems().stream().map(AdHocSubProcessActivityImpl::new).collect(Collectors.toList());
    }

    @Override
    public List<AdHocSubProcessActivityResponse.AdHocSubProcessActivity> getItems() {
        return this.items;
    }

    public static class AdHocSubProcessActivityImpl
    implements AdHocSubProcessActivityResponse.AdHocSubProcessActivity {
        private final Long processDefinitionKey;
        private final String processDefinitionId;
        private final String adHocSubProcessId;
        private final String elementId;
        private final String elementName;
        private final AdHocSubProcessActivityResultType type;
        private final String documentation;
        private final String tenantId;

        public AdHocSubProcessActivityImpl(AdHocSubProcessActivityResult result) {
            this.processDefinitionKey = Long.valueOf(result.getProcessDefinitionKey());
            this.processDefinitionId = result.getProcessDefinitionId();
            this.adHocSubProcessId = result.getAdHocSubProcessId();
            this.elementId = result.getElementId();
            this.elementName = result.getElementName();
            this.type = EnumUtil.convert(result.getType(), AdHocSubProcessActivityResultType.class);
            this.documentation = result.getDocumentation();
            this.tenantId = result.getTenantId();
        }

        @Override
        public Long getProcessDefinitionKey() {
            return this.processDefinitionKey;
        }

        @Override
        public String getProcessDefinitionId() {
            return this.processDefinitionId;
        }

        @Override
        public String getAdHocSubProcessId() {
            return this.adHocSubProcessId;
        }

        @Override
        public String getElementId() {
            return this.elementId;
        }

        @Override
        public String getElementName() {
            return this.elementName;
        }

        @Override
        public AdHocSubProcessActivityResultType getType() {
            return this.type;
        }

        @Override
        public String getDocumentation() {
            return this.documentation;
        }

        @Override
        public String getTenantId() {
            return this.tenantId;
        }
    }
}

