/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.client.protocol.rest.JobResultCorrections;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"denied", "deniedReason", "corrections"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobResult {
    public static final String JSON_PROPERTY_DENIED = "denied";
    @Nullable
    private Boolean denied;
    public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
    @Nullable
    private String deniedReason;
    public static final String JSON_PROPERTY_CORRECTIONS = "corrections";
    @Nullable
    private JobResultCorrections corrections;

    public JobResult denied(@Nullable Boolean denied) {
        this.denied = denied;
        return this;
    }

    @Nullable
    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDenied() {
        return this.denied;
    }

    @JsonProperty(value="denied")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDenied(@Nullable Boolean denied) {
        this.denied = denied;
    }

    public JobResult deniedReason(@Nullable String deniedReason) {
        this.deniedReason = deniedReason;
        return this;
    }

    @Nullable
    @JsonProperty(value="deniedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeniedReason() {
        return this.deniedReason;
    }

    @JsonProperty(value="deniedReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeniedReason(@Nullable String deniedReason) {
        this.deniedReason = deniedReason;
    }

    public JobResult corrections(@Nullable JobResultCorrections corrections) {
        this.corrections = corrections;
        return this;
    }

    @Nullable
    @JsonProperty(value="corrections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JobResultCorrections getCorrections() {
        return this.corrections;
    }

    @JsonProperty(value="corrections")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCorrections(@Nullable JobResultCorrections corrections) {
        this.corrections = corrections;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobResult jobResult = (JobResult)o;
        return Objects.equals(this.denied, jobResult.denied) && Objects.equals(this.deniedReason, jobResult.deniedReason) && Objects.equals(this.corrections, jobResult.corrections);
    }

    public int hashCode() {
        return Objects.hash(this.denied, this.deniedReason, this.corrections);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JobResult {\n");
        sb.append("    denied: ").append(this.toIndentedString(this.denied)).append("\n");
        sb.append("    deniedReason: ").append(this.toIndentedString(this.deniedReason)).append("\n");
        sb.append("    corrections: ").append(this.toIndentedString(this.corrections)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDenied() != null) {
            try {
                joiner.add(String.format("%sdenied%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDenied()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDeniedReason() != null) {
            try {
                joiner.add(String.format("%sdeniedReason%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDeniedReason()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCorrections() != null) {
            joiner.add(this.getCorrections().toUrlQueryString(prefix + JSON_PROPERTY_CORRECTIONS + suffix));
        }
        return joiner.toString();
    }
}

