/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.ModifyProcessInstanceVariableInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceModificationActivateInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceModificationInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.response.ModifyProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.response.ModifyProcessInstanceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class ModifyProcessInstanceCommandImpl
implements ModifyProcessInstanceCommandStep1,
ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 {
    private static final String EMPTY_SCOPE_ID = "";
    private static final long EMPTY_ANCESTOR_KEY = -1L;
    private final GatewayOuterClass.ModifyProcessInstanceRequest.Builder requestBuilder = GatewayOuterClass.ModifyProcessInstanceRequest.newBuilder();
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction latestActivateInstruction;
    private ProcessInstanceModificationActivateInstruction latestActivateInstructionRest;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final ProcessInstanceModificationInstruction httpRequestObject;
    private boolean useRest;
    private final long processInstanceKey;

    public ModifyProcessInstanceCommandImpl(long processInstanceKey, JsonMapper jsonMapper, GatewayGrpc.GatewayStub asyncStub, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, ZeebeClientConfiguration config) {
        this.requestBuilder.setProcessInstanceKey(processInstanceKey);
        this.jsonMapper = jsonMapper;
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new ProcessInstanceModificationInstruction();
        this.useRest = config.preferRestOverGrpc();
        this.processInstanceKey = processInstanceKey;
        this.requestTimeout(this.requestTimeout);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 activateElement(String elementId) {
        return this.activateElement(elementId, -1L);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 activateElement(String elementId, long ancestorElementInstanceKey) {
        return this.addActivateInstruction(elementId, ancestorElementInstanceKey);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 terminateElement(long elementInstanceKey) {
        this.requestBuilder.addTerminateInstructions(GatewayOuterClass.ModifyProcessInstanceRequest.TerminateInstruction.newBuilder().setElementInstanceKey(elementInstanceKey).build());
        this.httpRequestObject.addTerminateInstructionsItem(new ProcessInstanceModificationTerminateInstruction().elementInstanceKey(ParseUtil.keyToString(elementInstanceKey)));
        return this;
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 addActivateInstruction(String elementId, long ancestorElementInstanceKey) {
        ProcessInstanceModificationActivateInstruction activateInstructionsItem;
        GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction activateInstruction;
        this.latestActivateInstruction = activateInstruction = GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction.newBuilder().setElementId(elementId).setAncestorElementInstanceKey(ancestorElementInstanceKey).build();
        this.requestBuilder.addActivateInstructions(activateInstruction);
        this.latestActivateInstructionRest = activateInstructionsItem = new ProcessInstanceModificationActivateInstruction().elementId(elementId).ancestorElementInstanceKey(ParseUtil.keyToString(ancestorElementInstanceKey));
        this.httpRequestObject.addActivateInstructionsItem(activateInstructionsItem);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1 and() {
        this.latestActivateInstruction = null;
        this.latestActivateInstructionRest = null;
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(InputStream variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(InputStream variables, String scopeId) {
        if (this.useRest) {
            ArgumentUtil.ensureNotNull("variables", variables);
            String variablesString = this.jsonMapper.validateJson("variables", variables);
            this.buildRestRequest(variablesString, scopeId);
            return this;
        }
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(String variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(String variables, String scopeId) {
        if (this.useRest) {
            ArgumentUtil.ensureNotNull("variables", variables);
            this.buildRestRequest(variables, scopeId);
            return this;
        }
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Map<String, Object> variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Map<String, Object> variables, String scopeId) {
        if (this.useRest) {
            ArgumentUtil.ensureNotNull("variables", variables);
            String variablesString = this.jsonMapper.toJson(variables);
            this.buildRestRequest(variablesString, scopeId);
            return this;
        }
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Object variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Object variables, String scopeId) {
        if (this.useRest) {
            ArgumentUtil.ensureNotNull("variables", variables);
            String variablesString = this.jsonMapper.toJson(variables);
            this.buildRestRequest(variablesString, scopeId);
            return this;
        }
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariable(String key, Object value) {
        return this.withVariable(key, value, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariable(String key, Object value, String scopeId) {
        ArgumentUtil.ensureNotNull("key", key);
        return this.withVariables(Collections.singletonMap(key, value), scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(InputStream variables, String scopeId) {
        ArgumentUtil.ensureNotNull("variables", variables);
        String variablesString = this.jsonMapper.validateJson("variables", variables);
        return this.createVariableInstruction(variablesString, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(Map<String, Object> variables, String scopeId) {
        return this.createVariableInstruction((Object)variables, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(Object variables, String scopeId) {
        ArgumentUtil.ensureNotNull("variables", variables);
        String variablesString = this.jsonMapper.toJson(variables);
        return this.createVariableInstruction(variablesString, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(String variables, String scopeId) {
        return GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction.newBuilder().setVariables(this.jsonMapper.validateJson("variables", variables)).setScopeId(scopeId).build();
    }

    private ModifyProcessInstanceVariableInstruction buildVariableRequest(String variables, String scopeId) {
        return new ModifyProcessInstanceVariableInstruction().scopeId(scopeId).variables(this.jsonMapper.fromJsonAsMap(variables));
    }

    private void addVariableInstructionToLatestActivateInstruction(GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction) {
        this.requestBuilder.removeActivateInstructions(this.requestBuilder.getActivateInstructionsList().indexOf(this.latestActivateInstruction));
        this.latestActivateInstruction = this.latestActivateInstruction.toBuilder().addVariableInstructions(variableInstruction).build();
        this.requestBuilder.addActivateInstructions(this.latestActivateInstruction);
    }

    private void addVariableInstructionToLatestActivateInstruction(ModifyProcessInstanceVariableInstruction variableInstruction) {
        this.httpRequestObject.getActivateInstructions().remove(this.httpRequestObject.getActivateInstructions().indexOf(this.latestActivateInstructionRest));
        this.latestActivateInstructionRest = this.latestActivateInstructionRest.addVariableInstructionsItem(variableInstruction);
        this.httpRequestObject.addActivateInstructionsItem(this.latestActivateInstructionRest);
    }

    private void buildRestRequest(String variables, String scopeId) {
        ModifyProcessInstanceVariableInstruction instruction = this.buildVariableRequest(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(instruction);
    }

    @Override
    public FinalCommandStep<ModifyProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<ModifyProcessInstanceResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private ZeebeFuture<ModifyProcessInstanceResponse> sendRestRequest() {
        HttpZeebeFuture<ModifyProcessInstanceResponse> result = new HttpZeebeFuture<ModifyProcessInstanceResponse>();
        this.httpClient.post("/process-instances/" + this.processInstanceKey + "/modification", this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    private ZeebeFuture<ModifyProcessInstanceResponse> sendGrpcRequest() {
        GatewayOuterClass.ModifyProcessInstanceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<ModifyProcessInstanceResponse, GatewayOuterClass.ModifyProcessInstanceResponse> future = new RetriableClientFutureImpl<ModifyProcessInstanceResponse, GatewayOuterClass.ModifyProcessInstanceResponse>(ModifyProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.ModifyProcessInstanceRequest request, StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).modifyProcessInstance(request, streamObserver);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 operationReference(long operationReference) {
        this.requestBuilder.setOperationReference(operationReference);
        this.httpRequestObject.setOperationReference(operationReference);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

