/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientConfiguration;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.ActivateAdHocSubProcessActivitiesCommandStep1;
import io.camunda.client.api.command.ActivateJobsCommandStep1;
import io.camunda.client.api.command.AssignGroupToTenantCommandStep1;
import io.camunda.client.api.command.AssignMappingToGroupStep1;
import io.camunda.client.api.command.AssignMappingToTenantCommandStep1;
import io.camunda.client.api.command.AssignRoleToClientCommandStep1;
import io.camunda.client.api.command.AssignRoleToGroupCommandStep1;
import io.camunda.client.api.command.AssignRoleToMappingCommandStep1;
import io.camunda.client.api.command.AssignRoleToTenantCommandStep1;
import io.camunda.client.api.command.AssignRoleToUserCommandStep1;
import io.camunda.client.api.command.AssignUserTaskCommandStep1;
import io.camunda.client.api.command.AssignUserToGroupCommandStep1;
import io.camunda.client.api.command.AssignUserToTenantCommandStep1;
import io.camunda.client.api.command.BroadcastSignalCommandStep1;
import io.camunda.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.ClockPinCommandStep1;
import io.camunda.client.api.command.ClockResetCommandStep1;
import io.camunda.client.api.command.CompleteJobCommandStep1;
import io.camunda.client.api.command.CompleteUserTaskCommandStep1;
import io.camunda.client.api.command.CorrelateMessageCommandStep1;
import io.camunda.client.api.command.CreateAuthorizationCommandStep1;
import io.camunda.client.api.command.CreateBatchOperationCommandStep1;
import io.camunda.client.api.command.CreateDocumentBatchCommandStep1;
import io.camunda.client.api.command.CreateDocumentCommandStep1;
import io.camunda.client.api.command.CreateDocumentLinkCommandStep1;
import io.camunda.client.api.command.CreateGroupCommandStep1;
import io.camunda.client.api.command.CreateMappingCommandStep1;
import io.camunda.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.client.api.command.CreateRoleCommandStep1;
import io.camunda.client.api.command.CreateTenantCommandStep1;
import io.camunda.client.api.command.CreateUserCommandStep1;
import io.camunda.client.api.command.DeleteAuthorizationCommandStep1;
import io.camunda.client.api.command.DeleteDocumentCommandStep1;
import io.camunda.client.api.command.DeleteGroupCommandStep1;
import io.camunda.client.api.command.DeleteResourceCommandStep1;
import io.camunda.client.api.command.DeleteRoleCommandStep1;
import io.camunda.client.api.command.DeleteTenantCommandStep1;
import io.camunda.client.api.command.DeleteUserCommandStep1;
import io.camunda.client.api.command.DeployProcessCommandStep1;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.client.api.command.EvaluateDecisionCommandStep1;
import io.camunda.client.api.command.FailJobCommandStep1;
import io.camunda.client.api.command.MigrateProcessInstanceCommandStep1;
import io.camunda.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.client.api.command.PublishMessageCommandStep1;
import io.camunda.client.api.command.RemoveUserFromTenantCommandStep1;
import io.camunda.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.client.api.command.SetVariablesCommandStep1;
import io.camunda.client.api.command.StreamJobsCommandStep1;
import io.camunda.client.api.command.ThrowErrorCommandStep1;
import io.camunda.client.api.command.TopologyRequestStep1;
import io.camunda.client.api.command.UnassignGroupFromTenantCommandStep1;
import io.camunda.client.api.command.UnassignMappingFromGroupStep1;
import io.camunda.client.api.command.UnassignRoleFromClientCommandStep1;
import io.camunda.client.api.command.UnassignRoleFromGroupCommandStep1;
import io.camunda.client.api.command.UnassignRoleFromMappingCommandStep1;
import io.camunda.client.api.command.UnassignRoleFromTenantCommandStep1;
import io.camunda.client.api.command.UnassignRoleFromUserCommandStep1;
import io.camunda.client.api.command.UnassignUserFromGroupCommandStep1;
import io.camunda.client.api.command.UnassignUserTaskCommandStep1;
import io.camunda.client.api.command.UpdateAuthorizationCommandStep1;
import io.camunda.client.api.command.UpdateGroupCommandStep1;
import io.camunda.client.api.command.UpdateJobCommandStep1;
import io.camunda.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.client.api.command.UpdateRoleCommandStep1;
import io.camunda.client.api.command.UpdateTenantCommandStep1;
import io.camunda.client.api.command.UpdateTimeoutJobCommandStep1;
import io.camunda.client.api.command.UpdateUserCommandStep1;
import io.camunda.client.api.command.UpdateUserTaskCommandStep1;
import io.camunda.client.api.fetch.BatchOperationGetRequest;
import io.camunda.client.api.fetch.DecisionDefinitionGetRequest;
import io.camunda.client.api.fetch.DecisionDefinitionGetXmlRequest;
import io.camunda.client.api.fetch.DecisionInstanceGetRequest;
import io.camunda.client.api.fetch.DecisionRequirementsGetRequest;
import io.camunda.client.api.fetch.DecisionRequirementsGetXmlRequest;
import io.camunda.client.api.fetch.DocumentContentGetRequest;
import io.camunda.client.api.fetch.ElementInstanceGetRequest;
import io.camunda.client.api.fetch.GroupGetRequest;
import io.camunda.client.api.fetch.GroupsSearchRequest;
import io.camunda.client.api.fetch.IncidentGetRequest;
import io.camunda.client.api.fetch.MappingsByGroupSearchRequest;
import io.camunda.client.api.fetch.ProcessDefinitionGetFormRequest;
import io.camunda.client.api.fetch.ProcessDefinitionGetRequest;
import io.camunda.client.api.fetch.ProcessDefinitionGetXmlRequest;
import io.camunda.client.api.fetch.ProcessInstanceGetCallHierarchyRequest;
import io.camunda.client.api.fetch.ProcessInstanceGetRequest;
import io.camunda.client.api.fetch.RoleGetRequest;
import io.camunda.client.api.fetch.RolesByGroupSearchRequest;
import io.camunda.client.api.fetch.RolesSearchRequest;
import io.camunda.client.api.fetch.UserGetRequest;
import io.camunda.client.api.fetch.UserTaskGetFormRequest;
import io.camunda.client.api.fetch.UserTaskGetRequest;
import io.camunda.client.api.fetch.UsersByGroupSearchRequest;
import io.camunda.client.api.fetch.UsersSearchRequest;
import io.camunda.client.api.fetch.VariableGetRequest;
import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.DocumentReferenceResponse;
import io.camunda.client.api.search.request.AdHocSubProcessActivitySearchRequest;
import io.camunda.client.api.search.request.BatchOperationItemSearchRequest;
import io.camunda.client.api.search.request.BatchOperationSearchRequest;
import io.camunda.client.api.search.request.ClientsByRoleSearchRequest;
import io.camunda.client.api.search.request.DecisionDefinitionSearchRequest;
import io.camunda.client.api.search.request.DecisionInstanceSearchRequest;
import io.camunda.client.api.search.request.DecisionRequirementsSearchRequest;
import io.camunda.client.api.search.request.ElementInstanceSearchRequest;
import io.camunda.client.api.search.request.GroupsByRoleSearchRequest;
import io.camunda.client.api.search.request.IncidentSearchRequest;
import io.camunda.client.api.search.request.MappingsByRoleSearchRequest;
import io.camunda.client.api.search.request.ProcessDefinitionSearchRequest;
import io.camunda.client.api.search.request.ProcessInstanceSearchRequest;
import io.camunda.client.api.search.request.ProcessInstanceSequenceFlowsRequest;
import io.camunda.client.api.search.request.RolesByTenantSearchRequest;
import io.camunda.client.api.search.request.UserTaskSearchRequest;
import io.camunda.client.api.search.request.UserTaskVariableSearchRequest;
import io.camunda.client.api.search.request.UsersByRoleSearchRequest;
import io.camunda.client.api.search.request.VariableSearchRequest;
import io.camunda.client.api.statistics.request.ProcessDefinitionElementStatisticsRequest;
import io.camunda.client.api.statistics.request.ProcessInstanceElementStatisticsRequest;
import io.camunda.client.api.worker.JobClient;
import io.camunda.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.client.impl.CamundaCallCredentials;
import io.camunda.client.impl.Loggers;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.client.impl.command.ActivateAdHocSubProcessActivitiesCommandImpl;
import io.camunda.client.impl.command.AssignGroupToTenantCommandImpl;
import io.camunda.client.impl.command.AssignMappingToGroupCommandImpl;
import io.camunda.client.impl.command.AssignMappingToTenantCommandImpl;
import io.camunda.client.impl.command.AssignRoleToClientCommandImpl;
import io.camunda.client.impl.command.AssignRoleToGroupCommandImpl;
import io.camunda.client.impl.command.AssignRoleToMappingCommandImpl;
import io.camunda.client.impl.command.AssignRoleToTenantCommandImpl;
import io.camunda.client.impl.command.AssignRoleToUserCommandImpl;
import io.camunda.client.impl.command.AssignUserTaskCommandImpl;
import io.camunda.client.impl.command.AssignUserToGroupCommandImpl;
import io.camunda.client.impl.command.AssignUserToTenantCommandImpl;
import io.camunda.client.impl.command.BroadcastSignalCommandImpl;
import io.camunda.client.impl.command.CancelProcessInstanceCommandImpl;
import io.camunda.client.impl.command.ClockPinCommandImpl;
import io.camunda.client.impl.command.ClockResetCommandImpl;
import io.camunda.client.impl.command.CompleteUserTaskCommandImpl;
import io.camunda.client.impl.command.CorrelateMessageCommandImpl;
import io.camunda.client.impl.command.CreateAuthorizationCommandImpl;
import io.camunda.client.impl.command.CreateBatchOperationCommandImpl;
import io.camunda.client.impl.command.CreateDocumentBatchCommandImpl;
import io.camunda.client.impl.command.CreateDocumentCommandImpl;
import io.camunda.client.impl.command.CreateDocumentLinkCommandImpl;
import io.camunda.client.impl.command.CreateGroupCommandImpl;
import io.camunda.client.impl.command.CreateMappingCommandImpl;
import io.camunda.client.impl.command.CreateProcessInstanceCommandImpl;
import io.camunda.client.impl.command.CreateRoleCommandImpl;
import io.camunda.client.impl.command.CreateTenantCommandImpl;
import io.camunda.client.impl.command.CreateUserCommandImpl;
import io.camunda.client.impl.command.DeleteAuthorizationCommandImpl;
import io.camunda.client.impl.command.DeleteDocumentCommandImpl;
import io.camunda.client.impl.command.DeleteGroupCommandImpl;
import io.camunda.client.impl.command.DeleteResourceCommandImpl;
import io.camunda.client.impl.command.DeleteRoleCommandImpl;
import io.camunda.client.impl.command.DeleteTenantCommandImpl;
import io.camunda.client.impl.command.DeleteUserCommandImpl;
import io.camunda.client.impl.command.DeployProcessCommandImpl;
import io.camunda.client.impl.command.DeployResourceCommandImpl;
import io.camunda.client.impl.command.EvaluateDecisionCommandImpl;
import io.camunda.client.impl.command.JobUpdateCommandImpl;
import io.camunda.client.impl.command.JobUpdateRetriesCommandImpl;
import io.camunda.client.impl.command.JobUpdateTimeoutCommandImpl;
import io.camunda.client.impl.command.MigrateProcessInstanceCommandImpl;
import io.camunda.client.impl.command.ModifyProcessInstanceCommandImpl;
import io.camunda.client.impl.command.PublishMessageCommandImpl;
import io.camunda.client.impl.command.RemoveUserFromTenantCommandImpl;
import io.camunda.client.impl.command.ResolveIncidentCommandImpl;
import io.camunda.client.impl.command.SetVariablesCommandImpl;
import io.camunda.client.impl.command.StreamJobsCommandImpl;
import io.camunda.client.impl.command.TopologyRequestImpl;
import io.camunda.client.impl.command.UnassignGroupFromTenantCommandImpl;
import io.camunda.client.impl.command.UnassignMappingFromGroupCommandImpl;
import io.camunda.client.impl.command.UnassignRoleFromClientCommandImpl;
import io.camunda.client.impl.command.UnassignRoleFromGroupCommandImpl;
import io.camunda.client.impl.command.UnassignRoleFromMappingCommandImpl;
import io.camunda.client.impl.command.UnassignRoleFromTenantCommandImpl;
import io.camunda.client.impl.command.UnassignRoleFromUserCommandImpl;
import io.camunda.client.impl.command.UnassignUserFromGroupCommandImpl;
import io.camunda.client.impl.command.UnassignUserTaskCommandImpl;
import io.camunda.client.impl.command.UpdateAuthorizationCommandImpl;
import io.camunda.client.impl.command.UpdateGroupCommandImpl;
import io.camunda.client.impl.command.UpdateRoleCommandImpl;
import io.camunda.client.impl.command.UpdateTenantCommandImpl;
import io.camunda.client.impl.command.UpdateUserCommandImpl;
import io.camunda.client.impl.command.UpdateUserTaskCommandImpl;
import io.camunda.client.impl.fetch.BatchOperationGetRequestImpl;
import io.camunda.client.impl.fetch.DecisionDefinitionGetRequestImpl;
import io.camunda.client.impl.fetch.DecisionDefinitionGetXmlRequestImpl;
import io.camunda.client.impl.fetch.DecisionInstanceGetRequestImpl;
import io.camunda.client.impl.fetch.DecisionRequirementsGetRequestImpl;
import io.camunda.client.impl.fetch.DecisionRequirementsGetXmlRequestImpl;
import io.camunda.client.impl.fetch.DocumentContentGetRequestImpl;
import io.camunda.client.impl.fetch.ElementInstanceGetRequestImpl;
import io.camunda.client.impl.fetch.GroupGetRequestImpl;
import io.camunda.client.impl.fetch.IncidentGetRequestImpl;
import io.camunda.client.impl.fetch.ProcessDefinitionGetFormRequestImpl;
import io.camunda.client.impl.fetch.ProcessDefinitionGetRequestImpl;
import io.camunda.client.impl.fetch.ProcessDefinitionGetXmlRequestImpl;
import io.camunda.client.impl.fetch.ProcessInstanceGetCallHierarchyRequestImpl;
import io.camunda.client.impl.fetch.ProcessInstanceGetRequestImpl;
import io.camunda.client.impl.fetch.RoleGetRequestImpl;
import io.camunda.client.impl.fetch.UserGetRequestImpl;
import io.camunda.client.impl.fetch.UserTaskGetFormRequestImpl;
import io.camunda.client.impl.fetch.UserTaskGetRequestImpl;
import io.camunda.client.impl.fetch.VariableGetRequestImpl;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.http.HttpClientFactory;
import io.camunda.client.impl.search.request.AdHocSubProcessActivitySearchRequestImpl;
import io.camunda.client.impl.search.request.BatchOperationItemSearchRequestImpl;
import io.camunda.client.impl.search.request.BatchOperationSearchRequestImpl;
import io.camunda.client.impl.search.request.ClientsByRoleSearchRequestImpl;
import io.camunda.client.impl.search.request.DecisionDefinitionSearchRequestImpl;
import io.camunda.client.impl.search.request.DecisionInstanceSearchRequestImpl;
import io.camunda.client.impl.search.request.DecisionRequirementsSearchRequestImpl;
import io.camunda.client.impl.search.request.ElementInstanceSearchRequestImpl;
import io.camunda.client.impl.search.request.GroupSearchRequestImpl;
import io.camunda.client.impl.search.request.GroupsByRoleSearchRequestImpl;
import io.camunda.client.impl.search.request.IncidentSearchRequestImpl;
import io.camunda.client.impl.search.request.MappingsByGroupSearchRequestImpl;
import io.camunda.client.impl.search.request.MappingsByRoleSearchRequestImpl;
import io.camunda.client.impl.search.request.ProcessDefinitionSearchRequestImpl;
import io.camunda.client.impl.search.request.ProcessInstanceSearchRequestImpl;
import io.camunda.client.impl.search.request.ProcessInstanceSequenceFlowsRequestImpl;
import io.camunda.client.impl.search.request.RolesByGroupSearchRequestImpl;
import io.camunda.client.impl.search.request.RolesByTenantSearchRequestImpl;
import io.camunda.client.impl.search.request.RolesSearchRequestImpl;
import io.camunda.client.impl.search.request.UserTaskSearchRequestImpl;
import io.camunda.client.impl.search.request.UserTaskVariableSearchRequestImpl;
import io.camunda.client.impl.search.request.UsersByGroupSearchRequestImpl;
import io.camunda.client.impl.search.request.UsersByRoleSearchRequestImpl;
import io.camunda.client.impl.search.request.UsersSearchRequestImpl;
import io.camunda.client.impl.search.request.VariableSearchRequestImpl;
import io.camunda.client.impl.statistics.request.ProcessDefinitionElementStatisticsRequestImpl;
import io.camunda.client.impl.statistics.request.ProcessInstanceElementStatisticsRequestImpl;
import io.camunda.client.impl.util.ExecutorResource;
import io.camunda.client.impl.util.VersionUtil;
import io.camunda.client.impl.worker.JobClientImpl;
import io.camunda.client.impl.worker.JobWorkerBuilderImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class CamundaClientImpl
implements CamundaClient {
    private final CamundaClientConfiguration config;
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ManagedChannel channel;
    private final ExecutorResource executorResource;
    private final List<Closeable> closeables = new CopyOnWriteArrayList<Closeable>();
    private final JobClient jobClient;
    private final CredentialsProvider credentialsProvider;
    private final HttpClient httpClient;

    public CamundaClientImpl(CamundaClientConfiguration configuration) {
        this(configuration, CamundaClientImpl.buildChannel(configuration));
    }

    public CamundaClientImpl(CamundaClientConfiguration configuration, ManagedChannel channel) {
        this(configuration, channel, CamundaClientImpl.buildGatewayStub(channel, configuration));
    }

    public CamundaClientImpl(CamundaClientConfiguration configuration, ManagedChannel channel, HttpClient httpClient) {
        this(configuration, channel, CamundaClientImpl.buildGatewayStub(channel, configuration), CamundaClientImpl.buildExecutorService(configuration), httpClient);
    }

    public CamundaClientImpl(CamundaClientConfiguration configuration, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub) {
        this(configuration, channel, gatewayStub, CamundaClientImpl.buildExecutorService(configuration));
    }

    public CamundaClientImpl(CamundaClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ExecutorResource executorResource) {
        this(config, channel, gatewayStub, executorResource, CamundaClientImpl.buildHttpClient(config));
    }

    public CamundaClientImpl(CamundaClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ExecutorResource executorResource, HttpClient httpClient) {
        this.config = config;
        this.jsonMapper = config.getJsonMapper();
        this.channel = channel;
        this.asyncStub = gatewayStub;
        this.executorResource = executorResource;
        this.httpClient = httpClient;
        this.credentialsProvider = config.getCredentialsProvider() != null ? config.getCredentialsProvider() : new NoopCredentialsProvider();
        this.jobClient = this.newJobClient();
        this.httpClient.start();
    }

    private static HttpClient buildHttpClient(CamundaClientConfiguration config) {
        return new HttpClientFactory(config).createClient();
    }

    public static ManagedChannel buildChannel(CamundaClientConfiguration config) {
        Map<String, Object> serviceConfig;
        URI address = config.getGrpcAddress();
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort());
        CamundaClientImpl.configureConnectionSecurity(config, channelBuilder);
        channelBuilder.keepAliveTime(config.getKeepAlive().toMillis(), TimeUnit.MILLISECONDS);
        channelBuilder.userAgent("camunda-client-java/" + VersionUtil.getVersion());
        channelBuilder.maxInboundMessageSize(config.getMaxMessageSize());
        channelBuilder.maxInboundMetadataSize(config.getMaxMetadataSize());
        if (config.useDefaultRetryPolicy() && !(serviceConfig = CamundaClientImpl.defaultServiceConfig()).isEmpty()) {
            channelBuilder.defaultServiceConfig(serviceConfig);
            channelBuilder.enableRetry();
        }
        return channelBuilder.build();
    }

    private static CallCredentials buildCallCredentials(CamundaClientConfiguration config) {
        CredentialsProvider customCredentialsProvider = config.getCredentialsProvider();
        if (customCredentialsProvider == null) {
            return null;
        }
        return new CamundaCallCredentials(customCredentialsProvider);
    }

    private static void configureConnectionSecurity(CamundaClientConfiguration config, NettyChannelBuilder channelBuilder) {
        if (!config.isPlaintextConnectionEnabled()) {
            String certificatePath = config.getCaCertificatePath();
            SslContext sslContext = null;
            if (certificatePath != null) {
                if (certificatePath.isEmpty()) {
                    throw new IllegalArgumentException("Expected valid certificate path but found empty path instead.");
                }
                try (FileInputStream certInputStream = new FileInputStream(certificatePath);){
                    sslContext = GrpcSslContexts.forClient().trustManager((InputStream)certInputStream).build();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            channelBuilder.useTransportSecurity().sslContext(sslContext);
            if (config.getOverrideAuthority() != null) {
                channelBuilder.overrideAuthority(config.getOverrideAuthority());
            }
        } else {
            channelBuilder.usePlaintext();
        }
    }

    public static GatewayGrpc.GatewayStub buildGatewayStub(ManagedChannel channel, CamundaClientConfiguration config) {
        CallCredentials credentials = CamundaClientImpl.buildCallCredentials(config);
        GatewayGrpc.GatewayStub gatewayStub = (GatewayGrpc.GatewayStub)GatewayGrpc.newStub((Channel)channel).withCallCredentials(credentials);
        if (!config.getInterceptors().isEmpty()) {
            return (GatewayGrpc.GatewayStub)gatewayStub.withInterceptors(config.getInterceptors().toArray(new ClientInterceptor[0]));
        }
        return gatewayStub;
    }

    private static Map<String, Object> defaultServiceConfig() {
        ObjectMapper objectMapper = new ObjectMapper();
        URL defaultServiceConfig = ClassLoader.getSystemClassLoader().getResource("gateway-service-config.json");
        if (defaultServiceConfig == null) {
            Loggers.LOGGER.info("No default service config found on classpath; will not configure a default retry policy");
            return new HashMap<String, Object>();
        }
        try {
            return (Map)objectMapper.readValue(defaultServiceConfig, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            Loggers.LOGGER.warn("Failed to read default service config from classpath; will not configure a default retry policy", (Throwable)e);
            return new HashMap<String, Object>();
        }
    }

    private static ExecutorResource buildExecutorService(CamundaClientConfiguration configuration) {
        if (configuration.jobWorkerExecutor() != null) {
            return new ExecutorResource(configuration.jobWorkerExecutor(), configuration.ownsJobWorkerExecutor());
        }
        int threadCount = configuration.getNumJobWorkerExecutionThreads();
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(threadCount);
        return new ExecutorResource(executor, true);
    }

    @Override
    public TopologyRequestStep1 newTopologyRequest() {
        return new TopologyRequestImpl(this.asyncStub, this.httpClient, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.config.preferRestOverGrpc());
    }

    @Override
    public CamundaClientConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() {
        this.closeables.forEach(c -> {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.executorResource.close();
        this.channel.shutdownNow();
        try {
            if (!this.channel.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of in-flight request channel after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting termination of in-flight request channel", e);
        }
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed closing http client.", e);
        }
    }

    @Override
    public DeployProcessCommandStep1 newDeployCommand() {
        return new DeployProcessCommandImpl(this.asyncStub, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public DeployResourceCommandStep1 newDeployResourceCommand() {
        return new DeployResourceCommandImpl(this.asyncStub, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand() {
        return new CreateProcessInstanceCommandImpl(this.asyncStub, this.jsonMapper, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public ModifyProcessInstanceCommandStep1 newModifyProcessInstanceCommand(long processInstanceKey) {
        return new ModifyProcessInstanceCommandImpl(processInstanceKey, this.jsonMapper, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config);
    }

    @Override
    public MigrateProcessInstanceCommandStep1 newMigrateProcessInstanceCommand(long processInstanceKey) {
        return new MigrateProcessInstanceCommandImpl(processInstanceKey, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long processInstanceKey) {
        return new CancelProcessInstanceCommandImpl(this.asyncStub, processInstanceKey, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return new SetVariablesCommandImpl(this.asyncStub, this.jsonMapper, elementInstanceKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public EvaluateDecisionCommandStep1 newEvaluateDecisionCommand() {
        return new EvaluateDecisionCommandImpl(this.asyncStub, this.jsonMapper, this.config, this.credentialsProvider::shouldRetryRequest, this.httpClient);
    }

    @Override
    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return new PublishMessageCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc());
    }

    @Override
    public CorrelateMessageCommandStep1 newCorrelateMessageCommand() {
        return new CorrelateMessageCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public BroadcastSignalCommandStep1 newBroadcastSignalCommand() {
        return new BroadcastSignalCommandImpl(this.asyncStub, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.httpClient);
    }

    @Override
    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return new ResolveIncidentCommandImpl(this.asyncStub, incidentKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return new JobUpdateRetriesCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob job) {
        return this.newUpdateRetriesCommand(job.getKey());
    }

    @Override
    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(long jobKey) {
        return new JobUpdateTimeoutCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout(), this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config.preferRestOverGrpc(), this.jsonMapper);
    }

    @Override
    public UpdateTimeoutJobCommandStep1 newUpdateTimeoutCommand(ActivatedJob job) {
        return this.newUpdateTimeoutCommand(job.getKey());
    }

    @Override
    public JobWorkerBuilderStep1 newWorker() {
        return new JobWorkerBuilderImpl(this.config, this.jobClient, this.executorResource.executor(), this.closeables);
    }

    @Override
    public DeleteResourceCommandStep1 newDeleteResourceCommand(long resourceKey) {
        return new DeleteResourceCommandImpl(resourceKey, this.asyncStub, this.credentialsProvider::shouldRetryRequest, this.httpClient, this.config, this.jsonMapper);
    }

    @Override
    public CompleteUserTaskCommandStep1 newUserTaskCompleteCommand(long userTaskKey) {
        return new CompleteUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public AssignUserTaskCommandStep1 newUserTaskAssignCommand(long userTaskKey) {
        return new AssignUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public UpdateUserTaskCommandStep1 newUserTaskUpdateCommand(long userTaskKey) {
        return new UpdateUserTaskCommandImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public UnassignUserTaskCommandStep1 newUserTaskUnassignCommand(long userTaskKey) {
        return new UnassignUserTaskCommandImpl(this.httpClient, userTaskKey);
    }

    @Override
    public UpdateJobCommandStep1 newUpdateJobCommand(long jobKey) {
        return new JobUpdateCommandImpl(jobKey, this.httpClient, this.jsonMapper);
    }

    @Override
    public UpdateJobCommandStep1 newUpdateJobCommand(ActivatedJob job) {
        return this.newUpdateJobCommand(job.getKey());
    }

    @Override
    public ClockPinCommandStep1 newClockPinCommand() {
        return new ClockPinCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public ClockResetCommandStep1 newClockResetCommand() {
        return new ClockResetCommandImpl(this.httpClient);
    }

    @Override
    public ProcessDefinitionGetRequest newProcessDefinitionGetRequest(long processDefinitionKey) {
        return new ProcessDefinitionGetRequestImpl(this.httpClient, processDefinitionKey);
    }

    @Override
    public ProcessDefinitionGetXmlRequest newProcessDefinitionGetXmlRequest(long processDefinitionKey) {
        return new ProcessDefinitionGetXmlRequestImpl(this.httpClient, processDefinitionKey);
    }

    @Override
    public ProcessDefinitionGetFormRequest newProcessDefinitionGetFormRequest(long processDefinitionKey) {
        return new ProcessDefinitionGetFormRequestImpl(this.httpClient, processDefinitionKey);
    }

    @Override
    public ProcessDefinitionSearchRequest newProcessDefinitionSearchRequest() {
        return new ProcessDefinitionSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public ProcessDefinitionElementStatisticsRequest newProcessDefinitionElementStatisticsRequest(long processDefinitionKey) {
        return new ProcessDefinitionElementStatisticsRequestImpl(this.httpClient, this.jsonMapper, processDefinitionKey);
    }

    @Override
    public ProcessInstanceElementStatisticsRequest newProcessInstanceElementStatisticsRequest(long processInstanceKey) {
        return new ProcessInstanceElementStatisticsRequestImpl(this.httpClient, processInstanceKey);
    }

    @Override
    public ProcessInstanceSequenceFlowsRequest newProcessInstanceSequenceFlowsRequest(long processInstanceKey) {
        return new ProcessInstanceSequenceFlowsRequestImpl(this.httpClient, processInstanceKey);
    }

    @Override
    public ProcessInstanceGetRequest newProcessInstanceGetRequest(long processInstanceKey) {
        return new ProcessInstanceGetRequestImpl(this.httpClient, processInstanceKey);
    }

    @Override
    public ProcessInstanceSearchRequest newProcessInstanceSearchRequest() {
        return new ProcessInstanceSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public ElementInstanceSearchRequest newElementInstanceSearchRequest() {
        return new ElementInstanceSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public ElementInstanceGetRequest newElementInstanceGetRequest(long elementInstanceKey) {
        return new ElementInstanceGetRequestImpl(this.httpClient, elementInstanceKey);
    }

    @Override
    public AdHocSubProcessActivitySearchRequest newAdHocSubProcessActivitySearchRequest() {
        return new AdHocSubProcessActivitySearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public AdHocSubProcessActivitySearchRequest newAdHocSubProcessActivitySearchRequest(long processDefinitionKey, String adHocSubProcessId) {
        return this.newAdHocSubProcessActivitySearchRequest().filter(filter -> filter.processDefinitionKey(processDefinitionKey).adHocSubProcessId(adHocSubProcessId));
    }

    @Override
    public ActivateAdHocSubProcessActivitiesCommandStep1 newActivateAdHocSubProcessActivitiesCommand(String adHocSubProcessInstanceKey) {
        return new ActivateAdHocSubProcessActivitiesCommandImpl(this.httpClient, this.jsonMapper, adHocSubProcessInstanceKey);
    }

    @Override
    public UserTaskSearchRequest newUserTaskSearchRequest() {
        return new UserTaskSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionRequirementsSearchRequest newDecisionRequirementsSearchRequest() {
        return new DecisionRequirementsSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionDefinitionSearchRequest newDecisionDefinitionSearchRequest() {
        return new DecisionDefinitionSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionDefinitionGetRequest newDecisionDefinitionGetRequest(long decisionDefinitionKey) {
        return new DecisionDefinitionGetRequestImpl(this.httpClient, decisionDefinitionKey);
    }

    @Override
    public DecisionDefinitionGetXmlRequest newDecisionDefinitionGetXmlRequest(long decisionKey) {
        return new DecisionDefinitionGetXmlRequestImpl(this.httpClient, decisionKey);
    }

    @Override
    public DecisionInstanceSearchRequest newDecisionInstanceSearchRequest() {
        return new DecisionInstanceSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionInstanceGetRequest newDecisionInstanceGetRequest(String decisionInstanceId) {
        return new DecisionInstanceGetRequestImpl(this.httpClient, this.jsonMapper, decisionInstanceId);
    }

    @Override
    public IncidentSearchRequest newIncidentSearchRequest() {
        return new IncidentSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public IncidentGetRequest newIncidentGetRequest(long incidentKey) {
        return new IncidentGetRequestImpl(this.httpClient, incidentKey);
    }

    @Override
    public CreateRoleCommandStep1 newCreateRoleCommand() {
        return new CreateRoleCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public RoleGetRequest newRoleGetRequest(String roleId) {
        return new RoleGetRequestImpl(this.httpClient, roleId);
    }

    @Override
    public RolesSearchRequest newRolesSearchRequest() {
        return new RolesSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public UpdateRoleCommandStep1 newUpdateRoleCommand(String roleId) {
        return new UpdateRoleCommandImpl(this.httpClient, roleId, this.jsonMapper);
    }

    @Override
    public AssignRoleToMappingCommandStep1 newAssignRoleToMappingCommand() {
        return new AssignRoleToMappingCommandImpl(this.httpClient);
    }

    @Override
    public DeleteRoleCommandStep1 newDeleteRoleCommand(String roleId) {
        return new DeleteRoleCommandImpl(this.httpClient, roleId);
    }

    @Override
    public AssignRoleToGroupCommandStep1 newAssignRoleToGroupCommand() {
        return new AssignRoleToGroupCommandImpl(this.httpClient);
    }

    @Override
    public AssignRoleToClientCommandStep1 newAssignRoleToClientCommand() {
        return new AssignRoleToClientCommandImpl(this.httpClient);
    }

    @Override
    public ClientsByRoleSearchRequest newClientsByRoleSearchRequest(String roleId) {
        return new ClientsByRoleSearchRequestImpl(this.httpClient, this.jsonMapper, roleId);
    }

    @Override
    public AssignRoleToTenantCommandStep1 newAssignRoleToTenantCommand() {
        return new AssignRoleToTenantCommandImpl(this.httpClient);
    }

    @Override
    public UnassignRoleFromTenantCommandStep1 newUnassignRoleFromTenantCommand() {
        return new UnassignRoleFromTenantCommandImpl(this.httpClient);
    }

    @Override
    public RolesByTenantSearchRequest newRolesByTenantSearchRequest(String tenantId) {
        return new RolesByTenantSearchRequestImpl(this.httpClient, this.jsonMapper, tenantId);
    }

    @Override
    public UnassignRoleFromGroupCommandStep1 newUnassignRoleFromGroupCommand() {
        return new UnassignRoleFromGroupCommandImpl(this.httpClient);
    }

    @Override
    public UnassignRoleFromMappingCommandStep1 newUnassignRoleFromMappingCommand() {
        return new UnassignRoleFromMappingCommandImpl(this.httpClient);
    }

    @Override
    public UnassignRoleFromClientCommandStep1 newUnassignRoleFromClientCommand() {
        return new UnassignRoleFromClientCommandImpl(this.httpClient);
    }

    @Override
    public AssignRoleToUserCommandStep1 newAssignRoleToUserCommand() {
        return new AssignRoleToUserCommandImpl(this.httpClient);
    }

    @Override
    public UnassignRoleFromUserCommandStep1 newUnassignRoleFromUserCommand() {
        return new UnassignRoleFromUserCommandImpl(this.httpClient);
    }

    @Override
    public UsersByRoleSearchRequest newUsersByRoleSearchRequest(String roleId) {
        return new UsersByRoleSearchRequestImpl(this.httpClient, this.jsonMapper, roleId);
    }

    @Override
    public UsersSearchRequest newUsersSearchRequest() {
        return new UsersSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public CreateGroupCommandStep1 newCreateGroupCommand() {
        return new CreateGroupCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public UpdateGroupCommandStep1 newUpdateGroupCommand(String groupId) {
        return new UpdateGroupCommandImpl(groupId, this.httpClient, this.jsonMapper);
    }

    @Override
    public DeleteGroupCommandStep1 newDeleteGroupCommand(String groupId) {
        return new DeleteGroupCommandImpl(groupId, this.httpClient);
    }

    @Override
    public AssignUserToGroupCommandStep1 newAssignUserToGroupCommand() {
        return new AssignUserToGroupCommandImpl(this.httpClient);
    }

    @Override
    public UnassignUserFromGroupCommandStep1 newUnassignUserFromGroupCommand() {
        return new UnassignUserFromGroupCommandImpl(this.httpClient);
    }

    @Override
    public CreateUserCommandStep1 newUserCreateCommand() {
        return new CreateUserCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DeleteUserCommandStep1 newDeleteUserCommand(String username) {
        return new DeleteUserCommandImpl(this.httpClient, username);
    }

    @Override
    public UpdateUserCommandStep1 newUpdateUserCommand(String username) {
        return new UpdateUserCommandImpl(this.httpClient, username, this.jsonMapper);
    }

    @Override
    public UserGetRequest newUserGetRequest(String username) {
        return new UserGetRequestImpl(this.httpClient, username);
    }

    @Override
    public CreateMappingCommandStep1 newCreateMappingCommand() {
        return new CreateMappingCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DecisionRequirementsGetXmlRequest newDecisionRequirementsGetXmlRequest(long decisionRequirementsKey) {
        return new DecisionRequirementsGetXmlRequestImpl(this.httpClient, decisionRequirementsKey);
    }

    @Override
    public DecisionRequirementsGetRequest newDecisionRequirementsGetRequest(long decisionRequirementsKey) {
        return new DecisionRequirementsGetRequestImpl(this.httpClient, decisionRequirementsKey);
    }

    @Override
    public UserTaskGetFormRequest newUserTaskGetFormRequest(long userTaskKey) {
        return new UserTaskGetFormRequestImpl(this.httpClient, userTaskKey);
    }

    @Override
    public UserTaskGetRequest newUserTaskGetRequest(long userTaskKey) {
        return new UserTaskGetRequestImpl(this.httpClient, userTaskKey);
    }

    @Override
    public VariableSearchRequest newVariableSearchRequest() {
        return new VariableSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public VariableGetRequest newVariableGetRequest(long variableKey) {
        return new VariableGetRequestImpl(this.httpClient, variableKey);
    }

    @Override
    public UserTaskVariableSearchRequest newUserTaskVariableSearchRequest(long userTaskKey) {
        return new UserTaskVariableSearchRequestImpl(this.httpClient, this.jsonMapper, userTaskKey);
    }

    @Override
    public CreateDocumentCommandStep1 newCreateDocumentCommand() {
        return new CreateDocumentCommandImpl(this.jsonMapper, this.httpClient, this.config);
    }

    @Override
    public CreateDocumentBatchCommandStep1 newCreateDocumentBatchCommand() {
        return new CreateDocumentBatchCommandImpl(this.jsonMapper, this.httpClient, this.config);
    }

    @Override
    public DocumentContentGetRequest newDocumentContentGetRequest(String documentId) {
        return new DocumentContentGetRequestImpl(this.httpClient, documentId, null, null, this.config);
    }

    @Override
    public DocumentContentGetRequest newDocumentContentGetRequest(DocumentReferenceResponse documentReference) {
        return new DocumentContentGetRequestImpl(this.httpClient, documentReference.getDocumentId(), documentReference.getStoreId(), documentReference.getContentHash(), this.config);
    }

    @Override
    public CreateDocumentLinkCommandStep1 newCreateDocumentLinkCommand(String documentId) {
        return new CreateDocumentLinkCommandImpl(documentId, null, null, this.jsonMapper, this.httpClient, this.config);
    }

    @Override
    public CreateDocumentLinkCommandStep1 newCreateDocumentLinkCommand(DocumentReferenceResponse documentReference) {
        return new CreateDocumentLinkCommandImpl(documentReference.getDocumentId(), documentReference.getStoreId(), documentReference.getContentHash(), this.jsonMapper, this.httpClient, this.config);
    }

    @Override
    public DeleteDocumentCommandStep1 newDeleteDocumentCommand(String documentId) {
        return new DeleteDocumentCommandImpl(documentId, null, this.httpClient, this.config);
    }

    @Override
    public DeleteDocumentCommandStep1 newDeleteDocumentCommand(DocumentReferenceResponse documentReference) {
        return new DeleteDocumentCommandImpl(documentReference.getDocumentId(), documentReference.getStoreId(), this.httpClient, this.config);
    }

    @Override
    public CreateTenantCommandStep1 newCreateTenantCommand() {
        return new CreateTenantCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public UpdateTenantCommandStep1 newUpdateTenantCommand(String tenantId) {
        return new UpdateTenantCommandImpl(this.httpClient, this.jsonMapper, tenantId);
    }

    @Override
    public DeleteTenantCommandStep1 newDeleteTenantCommand(String tenantId) {
        return new DeleteTenantCommandImpl(this.httpClient).tenantId(tenantId);
    }

    @Override
    public AssignMappingToTenantCommandStep1 newAssignMappingToTenantCommand() {
        return new AssignMappingToTenantCommandImpl(this.httpClient);
    }

    @Override
    public AssignUserToTenantCommandStep1 newAssignUserToTenantCommand() {
        return new AssignUserToTenantCommandImpl(this.httpClient);
    }

    @Override
    public RemoveUserFromTenantCommandStep1 newUnassignUserFromTenantCommand() {
        return new RemoveUserFromTenantCommandImpl(this.httpClient);
    }

    @Override
    public AssignGroupToTenantCommandStep1 newAssignGroupToTenantCommand() {
        return new AssignGroupToTenantCommandImpl(this.httpClient);
    }

    @Override
    public UnassignGroupFromTenantCommandStep1 newUnassignGroupFromTenantCommand(String tenantId) {
        return new UnassignGroupFromTenantCommandImpl(this.httpClient, tenantId);
    }

    @Override
    public CreateAuthorizationCommandStep1 newCreateAuthorizationCommand() {
        return new CreateAuthorizationCommandImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public DeleteAuthorizationCommandStep1 newDeleteAuthorizationCommand(long authorizationKey) {
        return new DeleteAuthorizationCommandImpl(this.httpClient, authorizationKey);
    }

    @Override
    public UpdateAuthorizationCommandStep1 newUpdateAuthorizationCommand(long authorizationKey) {
        return new UpdateAuthorizationCommandImpl(this.httpClient, this.jsonMapper, authorizationKey);
    }

    @Override
    public CreateBatchOperationCommandStep1 newCreateBatchOperationCommand() {
        return new CreateBatchOperationCommandImpl.CreateBatchOperationCommandStep1Impl(this.httpClient, this.jsonMapper){};
    }

    @Override
    public BatchOperationGetRequest newBatchOperationGetRequest(String batchOperationId) {
        return new BatchOperationGetRequestImpl(this.httpClient, batchOperationId);
    }

    @Override
    public BatchOperationSearchRequest newBatchOperationSearchRequest() {
        return new BatchOperationSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public BatchOperationItemSearchRequest newBatchOperationItemsSearchRequest() {
        return new BatchOperationItemSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public AssignMappingToGroupStep1 newAssignMappingToGroupCommand() {
        return new AssignMappingToGroupCommandImpl(this.httpClient);
    }

    @Override
    public UnassignMappingFromGroupStep1 newUnassignMappingFromGroupCommand() {
        return new UnassignMappingFromGroupCommandImpl(this.httpClient);
    }

    @Override
    public GroupGetRequest newGroupGetRequest(String groupId) {
        return new GroupGetRequestImpl(this.httpClient, groupId);
    }

    @Override
    public GroupsSearchRequest newGroupsSearchRequest() {
        return new GroupSearchRequestImpl(this.httpClient, this.jsonMapper);
    }

    @Override
    public UsersByGroupSearchRequest newUsersByGroupSearchRequest(String groupId) {
        return new UsersByGroupSearchRequestImpl(this.httpClient, this.jsonMapper, groupId);
    }

    @Override
    public ProcessInstanceGetCallHierarchyRequest newProcessInstanceGetCallHierarchyRequest(Long processInstanceKey) {
        return new ProcessInstanceGetCallHierarchyRequestImpl(this.httpClient, processInstanceKey);
    }

    @Override
    public MappingsByGroupSearchRequest newMappingsByGroupSearchRequest(String groupId) {
        return new MappingsByGroupSearchRequestImpl(this.httpClient, this.jsonMapper, groupId);
    }

    @Override
    public MappingsByRoleSearchRequest newMappingsByRoleSearchRequest(String roleId) {
        return new MappingsByRoleSearchRequestImpl(this.httpClient, this.jsonMapper, roleId);
    }

    @Override
    public RolesByGroupSearchRequest newRolesByGroupSearchRequest(String groupId) {
        return new RolesByGroupSearchRequestImpl(this.httpClient, this.jsonMapper, groupId);
    }

    @Override
    public GroupsByRoleSearchRequest newGroupsByRoleSearchRequest(String roleId) {
        return new GroupsByRoleSearchRequestImpl(this.httpClient, this.jsonMapper, roleId);
    }

    private JobClient newJobClient() {
        return new JobClientImpl(this.asyncStub, this.httpClient, this.config, this.jsonMapper, this.credentialsProvider::shouldRetryRequest);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return this.jobClient.newCompleteCommand(jobKey);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(ActivatedJob job) {
        return this.newCompleteCommand(job.getKey());
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return this.jobClient.newFailCommand(jobKey);
    }

    @Override
    public FailJobCommandStep1 newFailCommand(ActivatedJob job) {
        return this.newFailCommand(job.getKey());
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(long jobKey) {
        return this.jobClient.newThrowErrorCommand(jobKey);
    }

    @Override
    public ThrowErrorCommandStep1 newThrowErrorCommand(ActivatedJob job) {
        return this.newThrowErrorCommand(job.getKey());
    }

    @Override
    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return this.jobClient.newActivateJobsCommand();
    }

    @Override
    public StreamJobsCommandStep1 newStreamJobsCommand() {
        return new StreamJobsCommandImpl(this.asyncStub, this.jsonMapper, this.credentialsProvider::shouldRetryRequest, this.config);
    }
}

