/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignGroupToTenantCommandStep1;
import io.camunda.client.api.response.AssignGroupToTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class AssignGroupToTenantCommandImpl
implements AssignGroupToTenantCommandStep1,
AssignGroupToTenantCommandStep1.AssignGroupToTenantCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String groupId;
    private String tenantId;

    public AssignGroupToTenantCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignGroupToTenantCommandStep1.AssignGroupToTenantCommandStep2 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public AssignGroupToTenantCommandStep1.AssignGroupToTenantCommandStep2 tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AssignGroupToTenantCommandStep1.AssignGroupToTenantCommandStep2 requestTimeout(Duration timeout) {
        this.httpRequestConfig.setResponseTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignGroupToTenantResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<AssignGroupToTenantResponse> result = new HttpCamundaFuture<AssignGroupToTenantResponse>();
        this.httpClient.put("/tenants/" + this.tenantId + "/groups/" + this.groupId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

