/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignMappingToGroupStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignMappingToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignMappingToGroupCommandImpl
implements AssignMappingToGroupStep1,
AssignMappingToGroupStep1.AssignMappingToGroupStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String mappingId;
    private String groupId;

    public AssignMappingToGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignMappingToGroupStep1.AssignMappingToGroupStep2 mappingId(String mappingId) {
        this.mappingId = mappingId;
        return this;
    }

    @Override
    public AssignMappingToGroupStep1.AssignMappingToGroupStep2 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignMappingToGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignMappingToGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        ArgumentUtil.ensureNotNullNorEmpty("mappingId", this.mappingId);
        HttpCamundaFuture<AssignMappingToGroupResponse> result = new HttpCamundaFuture<AssignMappingToGroupResponse>();
        this.httpClient.put("/groups/" + this.groupId + "/mapping-rules/" + this.mappingId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

