/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignRoleToClientCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignRoleToClientResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignRoleToClientCommandImpl
implements AssignRoleToClientCommandStep1,
AssignRoleToClientCommandStep1.AssignRoleToClientCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String roleId;
    private String clientId;

    public AssignRoleToClientCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignRoleToClientCommandStep1.AssignRoleToClientCommandStep2 roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Override
    public AssignRoleToClientCommandStep1.AssignRoleToClientCommandStep2 clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignRoleToClientResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignRoleToClientResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        ArgumentUtil.ensureNotNullNorEmpty("clientId", this.clientId);
        HttpCamundaFuture<AssignRoleToClientResponse> result = new HttpCamundaFuture<AssignRoleToClientResponse>();
        this.httpClient.put("/roles/" + this.roleId + "/clients/" + this.clientId, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

