/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignUserToGroupCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignUserToGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignUserToGroupCommandImpl
implements AssignUserToGroupCommandStep1,
AssignUserToGroupCommandStep1.AssignUserToGroupCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String username;
    private String groupId;

    public AssignUserToGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignUserToGroupCommandStep1.AssignUserToGroupCommandStep2 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public AssignUserToGroupCommandStep1.AssignUserToGroupCommandStep2 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignUserToGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignUserToGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        ArgumentUtil.ensureNotNullNorEmpty("username", this.username);
        HttpCamundaFuture<AssignUserToGroupResponse> result = new HttpCamundaFuture<AssignUserToGroupResponse>();
        this.httpClient.put("/groups/" + this.groupId + "/users/" + this.username, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

