/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.CreateBatchOperationCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.MigrationPlan;
import io.camunda.client.api.response.CreateBatchOperationResponse;
import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.TypedSearchRequest;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.CreateBatchOperationResponseImpl;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.protocol.rest.BatchOperationCreatedResult;
import io.camunda.client.protocol.rest.BatchOperationTypeEnum;
import io.camunda.client.protocol.rest.MigrateProcessInstanceMappingInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceMigrationBatchOperationPlan;
import io.camunda.client.protocol.rest.ProcessInstanceMigrationBatchOperationRequest;
import io.camunda.client.protocol.rest.ProcessInstanceModificationBatchOperationRequest;
import io.camunda.client.protocol.rest.ProcessInstanceModificationMoveBatchOperationInstruction;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hc.client5.http.config.RequestConfig;

public class CreateBatchOperationCommandImpl<E extends TypedSearchRequest.SearchRequestFilter>
implements CreateBatchOperationCommandStep1.ProcessInstanceMigrationStep<E>,
CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep2<E>,
CreateBatchOperationCommandStep1.ProcessInstanceModificationStep<E>,
CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep3<E> {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;
    private final BatchOperationTypeEnum type;
    private final Function<Consumer<E>, E> filterFactory;
    private E filter;
    private final ProcessInstanceMigrationBatchOperationPlan migrationPlan = new ProcessInstanceMigrationBatchOperationPlan();
    private final List<ProcessInstanceModificationMoveBatchOperationInstruction> moveInstructions = new ArrayList<ProcessInstanceModificationMoveBatchOperationInstruction>();

    public CreateBatchOperationCommandImpl(HttpClient httpClient, JsonMapper jsonMapper, BatchOperationTypeEnum type, Function<Consumer<E>, E> filterFactory) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.type = type;
        this.filterFactory = filterFactory;
    }

    @Override
    public CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep3<E> filter(E filter) {
        this.filter = (TypedSearchRequest.SearchRequestFilter)Objects.requireNonNull(filter, "must specify a filter");
        return this;
    }

    @Override
    public CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep3<E> filter(Consumer<E> fn) {
        Objects.requireNonNull(fn, "must specify a filter consumer");
        this.filter = (TypedSearchRequest.SearchRequestFilter)this.filterFactory.apply(fn);
        return this;
    }

    @Override
    public CreateBatchOperationCommandStep1.ProcessInstanceModificationStep<E> addMoveInstruction(String sourceElementId, String targetElementId) {
        Objects.requireNonNull(sourceElementId, "must specify a source element id");
        Objects.requireNonNull(targetElementId, "must specify a target element id");
        this.moveInstructions.add(new ProcessInstanceModificationMoveBatchOperationInstruction().sourceElementId(sourceElementId).targetElementId(targetElementId));
        return this;
    }

    @Override
    public FinalCommandStep<CreateBatchOperationResponse> requestTimeout(Duration requestTimeout) {
        ArgumentUtil.ensurePositive("requestTimeout", requestTimeout);
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<CreateBatchOperationResponse> send() {
        HttpCamundaFuture<CreateBatchOperationResponse> result = new HttpCamundaFuture<CreateBatchOperationResponse>();
        CreateBatchOperationResponseImpl response = new CreateBatchOperationResponseImpl();
        this.httpClient.post(this.getUrl(), this.jsonMapper.toJson(this.getBody()), this.httpRequestConfig.build(), BatchOperationCreatedResult.class, response::setResponse, result);
        return result;
    }

    private String getUrl() {
        switch (this.type) {
            case CANCEL_PROCESS_INSTANCE: {
                return "/process-instances/cancellation";
            }
            case RESOLVE_INCIDENT: {
                return "/process-instances/incident-resolution";
            }
            case MIGRATE_PROCESS_INSTANCE: {
                return "/process-instances/migration";
            }
            case MODIFY_PROCESS_INSTANCE: {
                return "/process-instances/modification";
            }
        }
        throw new IllegalArgumentException("Unsupported batch operation type: " + (Object)((Object)this.type));
    }

    private Object getBody() {
        if (this.type == BatchOperationTypeEnum.MIGRATE_PROCESS_INSTANCE) {
            return new ProcessInstanceMigrationBatchOperationRequest().filter((io.camunda.client.protocol.rest.ProcessInstanceFilter)TypedSearchRequestPropertyProvider.provideSearchRequestProperty(this.filter)).migrationPlan(this.migrationPlan);
        }
        if (this.type == BatchOperationTypeEnum.MODIFY_PROCESS_INSTANCE) {
            return new ProcessInstanceModificationBatchOperationRequest().filter((io.camunda.client.protocol.rest.ProcessInstanceFilter)TypedSearchRequestPropertyProvider.provideSearchRequestProperty(this.filter)).moveInstructions(this.moveInstructions);
        }
        return TypedSearchRequestPropertyProvider.provideSearchRequestProperty(this.filter);
    }

    @Override
    public CreateBatchOperationCommandStep1.ProcessInstanceMigrationStep<E> migrationPlan(MigrationPlan migrationPlan) {
        this.targetProcessDefinitionKey(migrationPlan.getTargetProcessDefinitionKey());
        migrationPlan.getMappingInstructions().forEach(instruction -> this.addMappingInstruction(instruction.getSourceElementId(), instruction.getTargetElementId()));
        return this;
    }

    @Override
    public CreateBatchOperationCommandStep1.ProcessInstanceMigrationStep<E> addMappingInstruction(String sourceElementId, String targetElementId) {
        Objects.requireNonNull(sourceElementId, "must specify a source element id");
        Objects.requireNonNull(targetElementId, "must specify a target element id");
        this.migrationPlan.addMappingInstructionsItem(new MigrateProcessInstanceMappingInstruction().sourceElementId(sourceElementId).targetElementId(targetElementId));
        return this;
    }

    @Override
    public CreateBatchOperationCommandStep1.ProcessInstanceMigrationStep<E> targetProcessDefinitionKey(long targetProcessDefinitionKey) {
        this.migrationPlan.targetProcessDefinitionKey(String.valueOf(targetProcessDefinitionKey));
        return this;
    }

    public static class CreateBatchOperationCommandStep1Impl
    implements CreateBatchOperationCommandStep1 {
        private final HttpClient httpClient;
        private final JsonMapper jsonMapper;

        public CreateBatchOperationCommandStep1Impl(HttpClient httpClient, JsonMapper jsonMapper) {
            this.httpClient = httpClient;
            this.jsonMapper = jsonMapper;
        }

        @Override
        public CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep2<ProcessInstanceFilter> processInstanceCancel() {
            return new CreateBatchOperationCommandImpl<ProcessInstanceFilter>(this.httpClient, this.jsonMapper, BatchOperationTypeEnum.CANCEL_PROCESS_INSTANCE, SearchRequestBuilders::processInstanceFilter);
        }

        @Override
        public CreateBatchOperationCommandStep1.CreateBatchOperationCommandStep2<ProcessInstanceFilter> resolveIncident() {
            return new CreateBatchOperationCommandImpl<ProcessInstanceFilter>(this.httpClient, this.jsonMapper, BatchOperationTypeEnum.RESOLVE_INCIDENT, SearchRequestBuilders::processInstanceFilter);
        }

        @Override
        public CreateBatchOperationCommandStep1.ProcessInstanceMigrationStep<ProcessInstanceFilter> migrateProcessInstance() {
            return new CreateBatchOperationCommandImpl<ProcessInstanceFilter>(this.httpClient, this.jsonMapper, BatchOperationTypeEnum.MIGRATE_PROCESS_INSTANCE, SearchRequestBuilders::processInstanceFilter);
        }

        @Override
        public CreateBatchOperationCommandStep1.ProcessInstanceModificationStep<ProcessInstanceFilter> modifyProcessInstance() {
            return new CreateBatchOperationCommandImpl<ProcessInstanceFilter>(this.httpClient, this.jsonMapper, BatchOperationTypeEnum.MODIFY_PROCESS_INSTANCE, SearchRequestBuilders::processInstanceFilter);
        }
    }
}

