/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.RemoveUserFromTenantCommandStep1;
import io.camunda.client.api.response.RemoveUserFromTenantResponse;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public final class RemoveUserFromTenantCommandImpl
implements RemoveUserFromTenantCommandStep1,
RemoveUserFromTenantCommandStep1.RemoveUserFromTenantCommandStep2 {
    private String tenantId;
    private String username;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public RemoveUserFromTenantCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public RemoveUserFromTenantCommandStep1.RemoveUserFromTenantCommandStep2 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public RemoveUserFromTenantCommandStep1.RemoveUserFromTenantCommandStep2 tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public FinalCommandStep<RemoveUserFromTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<RemoveUserFromTenantResponse> send() {
        HttpCamundaFuture<RemoveUserFromTenantResponse> result = new HttpCamundaFuture<RemoveUserFromTenantResponse>();
        String endpoint = String.format("/tenants/%s/users/%s", this.tenantId, this.username);
        this.httpClient.delete(endpoint, null, this.httpRequestConfig.build(), result);
        return result;
    }
}

