/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.client.api.response.ResolveIncidentResponse;
import io.camunda.client.impl.RetriableClientFutureImpl;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.ResolveIncidentResponseImpl;
import io.camunda.client.protocol.rest.IncidentResolutionRequest;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.hc.client5.http.config.RequestConfig;

public final class ResolveIncidentCommandImpl
implements ResolveIncidentCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.ResolveIncidentRequest.Builder builder;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private Duration requestTimeout;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private boolean useRest;
    private final long incidentKey;
    private final IncidentResolutionRequest incidentResolutionRequest;
    private final JsonMapper jsonMapper;

    public ResolveIncidentCommandImpl(GatewayGrpc.GatewayStub asyncStub, long incidentKey, Duration requestTimeout, Predicate<CredentialsProvider.StatusCode> retryPredicate, HttpClient httpClient, boolean preferRestOverGrpc, JsonMapper jsonMapper) {
        this.asyncStub = asyncStub;
        this.builder = GatewayOuterClass.ResolveIncidentRequest.newBuilder().setIncidentKey(incidentKey);
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.useRest = preferRestOverGrpc;
        this.incidentKey = incidentKey;
        this.incidentResolutionRequest = new IncidentResolutionRequest();
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<ResolveIncidentResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<ResolveIncidentResponse> send() {
        if (this.useRest) {
            return this.sendRestRequest();
        }
        return this.sendGrpcRequest();
    }

    private CamundaFuture<ResolveIncidentResponse> sendRestRequest() {
        HttpCamundaFuture<ResolveIncidentResponse> result = new HttpCamundaFuture<ResolveIncidentResponse>();
        this.httpClient.post("/incidents/" + this.incidentKey + "/resolution", this.jsonMapper.toJson(this.incidentResolutionRequest), this.httpRequestConfig.build(), result);
        return result;
    }

    private CamundaFuture<ResolveIncidentResponse> sendGrpcRequest() {
        GatewayOuterClass.ResolveIncidentRequest request = this.builder.build();
        RetriableClientFutureImpl<ResolveIncidentResponse, GatewayOuterClass.ResolveIncidentResponse> future = new RetriableClientFutureImpl<ResolveIncidentResponse, GatewayOuterClass.ResolveIncidentResponse>(ResolveIncidentResponseImpl::new, this.retryPredicate, streamObserver -> this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ResolveIncidentResponse>)streamObserver));
        this.sendGrpcRequest(request, (StreamObserver<GatewayOuterClass.ResolveIncidentResponse>)future);
        return future;
    }

    private void sendGrpcRequest(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).resolveIncident(request, streamObserver);
    }

    @Override
    public ResolveIncidentCommandStep1 operationReference(long operationReference) {
        this.incidentResolutionRequest.setOperationReference(operationReference);
        this.builder.setOperationReference(operationReference);
        return this;
    }

    @Override
    public ResolveIncidentCommandStep1 useRest() {
        this.useRest = true;
        return this;
    }

    @Override
    public ResolveIncidentCommandStep1 useGrpc() {
        this.useRest = false;
        return this;
    }
}

