/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UnassignUserFromGroupCommandStep1;
import io.camunda.client.api.response.UnassignUserFromGroupResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UnassignUserFromGroupCommandImpl
implements UnassignUserFromGroupCommandStep1,
UnassignUserFromGroupCommandStep1.UnassignUserFromGroupCommandStep2 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String username;
    private String groupId;

    public UnassignUserFromGroupCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UnassignUserFromGroupCommandStep1.UnassignUserFromGroupCommandStep2 username(String username) {
        this.username = username;
        return this;
    }

    @Override
    public UnassignUserFromGroupCommandStep1.UnassignUserFromGroupCommandStep2 groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public FinalCommandStep<UnassignUserFromGroupResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UnassignUserFromGroupResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        ArgumentUtil.ensureNotNullNorEmpty("username", this.username);
        HttpCamundaFuture<UnassignUserFromGroupResponse> result = new HttpCamundaFuture<UnassignUserFromGroupResponse>();
        this.httpClient.delete("/groups/" + this.groupId + "/users/" + this.username, this.httpRequestConfig.build(), result);
        return result;
    }
}

