/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.command.UpdateUserCommandStep1;
import io.camunda.client.api.response.UpdateUserResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.protocol.rest.UserUpdateRequest;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class UpdateUserCommandImpl
implements UpdateUserCommandStep1 {
    private final String username;
    private final UserUpdateRequest request;
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public UpdateUserCommandImpl(HttpClient httpClient, String username, JsonMapper jsonMapper) {
        this.username = username;
        this.request = new UserUpdateRequest();
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public UpdateUserCommandStep1 name(String name) {
        this.request.setName(name);
        return this;
    }

    @Override
    public UpdateUserCommandStep1 email(String email) {
        this.request.setEmail(email);
        return this;
    }

    @Override
    public UpdateUserCommandStep1 password(String password) {
        this.request.setPassword(password);
        return this;
    }

    @Override
    public FinalCommandStep<UpdateUserResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<UpdateUserResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("name", this.request.getName());
        ArgumentUtil.ensureNotNullNorEmpty("email", this.request.getEmail());
        HttpCamundaFuture<UpdateUserResponse> result = new HttpCamundaFuture<UpdateUserResponse>();
        this.httpClient.put("/users/" + this.username, this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), result);
        return result;
    }
}

