/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.fetch;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.fetch.BatchOperationGetRequest;
import io.camunda.client.api.search.response.BatchOperation;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.BatchOperationResponse;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class BatchOperationGetRequestImpl
implements BatchOperationGetRequest {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final String batchOperationId;

    public BatchOperationGetRequestImpl(HttpClient httpClient, String batchOperationId) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.batchOperationId = batchOperationId;
    }

    @Override
    public FinalCommandStep<BatchOperation> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<BatchOperation> send() {
        HttpCamundaFuture<BatchOperation> result = new HttpCamundaFuture<BatchOperation>();
        this.httpClient.get(String.format("/batch-operations/%s", this.batchOperationId), this.httpRequestConfig.build(), BatchOperationResponse.class, SearchResponseMapper::toBatchOperationGetResponse, result);
        return result;
    }
}

