/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.GroupFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.GroupsByRoleSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Group;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.GroupSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.GroupSearchQueryRequest;
import io.camunda.client.protocol.rest.GroupSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class GroupsByRoleSearchRequestImpl
extends TypedSearchRequestPropertyProvider<GroupSearchQueryRequest>
implements GroupsByRoleSearchRequest {
    private final GroupSearchQueryRequest request;
    private final String roleId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public GroupsByRoleSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String roleId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.roleId = roleId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new GroupSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Group> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Group>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<SearchResponse<Group>> result = new HttpCamundaFuture<SearchResponse<Group>>();
        this.httpClient.post(String.format("/roles/%s/groups/search", this.roleId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), GroupSearchQueryResult.class, SearchResponseMapper::toGroupsResponse, result);
        return result;
    }

    @Override
    public GroupsByRoleSearchRequest filter(GroupFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.GroupFilter)GroupsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsByRoleSearchRequest filter(Consumer<GroupFilter> fn) {
        return this.filter(SearchRequestBuilders.groupFilter(fn));
    }

    @Override
    public GroupsByRoleSearchRequest sort(GroupSort value) {
        this.request.setSort(SearchRequestSortMapper.toGroupSearchQuerySortRequest((List)GroupsByRoleSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public GroupsByRoleSearchRequest sort(Consumer<GroupSort> fn) {
        return this.sort(SearchRequestBuilders.groupSort(fn));
    }

    @Override
    public GroupsByRoleSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)GroupsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsByRoleSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected GroupSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

