/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.MappingsByRoleSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Mapping;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.MappingSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.MappingFilter;
import io.camunda.client.protocol.rest.MappingSearchQueryRequest;
import io.camunda.client.protocol.rest.MappingSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class MappingsByRoleSearchRequestImpl
extends TypedSearchRequestPropertyProvider<MappingSearchQueryRequest>
implements MappingsByRoleSearchRequest {
    private final MappingSearchQueryRequest request;
    private final String roleId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public MappingsByRoleSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String roleId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.roleId = roleId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new MappingSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Mapping> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Mapping>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<SearchResponse<Mapping>> result = new HttpCamundaFuture<SearchResponse<Mapping>>();
        this.httpClient.post(String.format("/roles/%s/mapping-rules/search", this.roleId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), MappingSearchQueryResult.class, SearchResponseMapper::toMappingsResponse, result);
        return result;
    }

    @Override
    public MappingsByRoleSearchRequest filter(io.camunda.client.api.search.filter.MappingFilter value) {
        this.request.setFilter((MappingFilter)MappingsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MappingsByRoleSearchRequest filter(Consumer<io.camunda.client.api.search.filter.MappingFilter> fn) {
        return this.filter(SearchRequestBuilders.mappingFilter(fn));
    }

    @Override
    public MappingsByRoleSearchRequest sort(MappingSort value) {
        this.request.setSort(SearchRequestSortMapper.toMappingSearchQuerySortRequest((List)MappingsByRoleSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public MappingsByRoleSearchRequest sort(Consumer<MappingSort> fn) {
        return this.sort(SearchRequestBuilders.mappingSort(fn));
    }

    @Override
    public MappingsByRoleSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)MappingsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public MappingsByRoleSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected MappingSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

