/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.RolesByGroupSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Role;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.RoleSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.RoleFilter;
import io.camunda.client.protocol.rest.RoleSearchQueryRequest;
import io.camunda.client.protocol.rest.RoleSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class RolesByGroupSearchRequestImpl
extends TypedSearchRequestPropertyProvider<RoleSearchQueryRequest>
implements RolesByGroupSearchRequest {
    private final RoleSearchQueryRequest request;
    private final String groupId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public RolesByGroupSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String groupId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.groupId = groupId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Role> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Role>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("groupId", this.groupId);
        HttpCamundaFuture<SearchResponse<Role>> result = new HttpCamundaFuture<SearchResponse<Role>>();
        this.httpClient.post(String.format("/groups/%s/roles/search", this.groupId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleSearchQueryResult.class, SearchResponseMapper::toRolesResponse, result);
        return result;
    }

    @Override
    public RolesByGroupSearchRequest filter(io.camunda.client.api.search.filter.RoleFilter value) {
        this.request.setFilter((RoleFilter)RolesByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public RolesByGroupSearchRequest filter(Consumer<io.camunda.client.api.search.filter.RoleFilter> fn) {
        return this.filter(SearchRequestBuilders.roleFilter(fn));
    }

    @Override
    public RolesByGroupSearchRequest sort(RoleSort value) {
        this.request.setSort(SearchRequestSortMapper.toRoleSearchQuerySortRequest((List)RolesByGroupSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public RolesByGroupSearchRequest sort(Consumer<RoleSort> fn) {
        return this.sort(SearchRequestBuilders.roleSort(fn));
    }

    @Override
    public RolesByGroupSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)RolesByGroupSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public RolesByGroupSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected RoleSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

