/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.fetch.UsersSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.User;
import io.camunda.client.api.search.sort.UserSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.UserFilter;
import io.camunda.client.protocol.rest.UserSearchQueryRequest;
import io.camunda.client.protocol.rest.UserSearchResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsersSearchRequestImpl
extends TypedSearchRequestPropertyProvider<UserSearchQueryRequest>
implements UsersSearchRequest {
    private final UserSearchQueryRequest request;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final JsonMapper jsonMapper;

    public UsersSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new UserSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<User> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<User>> send() {
        HttpCamundaFuture<SearchResponse<User>> result = new HttpCamundaFuture<SearchResponse<User>>();
        this.httpClient.post("/users/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), UserSearchResult.class, SearchResponseMapper::toUsersResponse, result);
        return result;
    }

    @Override
    public UsersSearchRequest filter(io.camunda.client.api.search.filter.UserFilter value) {
        this.request.setFilter((UserFilter)UsersSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersSearchRequest filter(Consumer<io.camunda.client.api.search.filter.UserFilter> fn) {
        return this.filter(SearchRequestBuilders.userFilter(fn));
    }

    @Override
    public UsersSearchRequest sort(UserSort value) {
        this.request.setSort(SearchRequestSortMapper.toUserSearchQuerySortRequest((List)UsersSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UsersSearchRequest sort(Consumer<UserSort> fn) {
        return this.sort(SearchRequestBuilders.userSort(fn));
    }

    @Override
    public UsersSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UsersSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected UserSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

