/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.client.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.UpdateJobCommandStep1;
import io.camunda.zeebe.client.api.response.UpdateJobResponse;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.protocol.rest.JobChangeset;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class JobUpdateCommandImpl
implements UpdateJobCommandStep1,
UpdateJobCommandStep1.UpdateJobCommandStep2 {
    private final JobUpdateRequest httpRequestObject;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private final long jobKey;
    private final JsonMapper jsonMapper;

    public JobUpdateCommandImpl(long jobKey, HttpClient httpClient, JsonMapper jsonMapper) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.httpRequestObject = new JobUpdateRequest();
        this.jobKey = jobKey;
        this.jsonMapper = jsonMapper;
    }

    @Override
    public FinalCommandStep<UpdateJobResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<UpdateJobResponse> send() {
        HttpZeebeFuture<UpdateJobResponse> result = new HttpZeebeFuture<UpdateJobResponse>();
        this.httpClient.patch("/jobs/" + this.jobKey, this.jsonMapper.toJson(this.httpRequestObject), this.httpRequestConfig.build(), result);
        return result;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 update(JobChangeset jobChangeset) {
        this.httpRequestObject.setChangeset(Optional.ofNullable(jobChangeset).map(JobChangeset::getDelegate).orElse(null));
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 update(Integer retries, Long timeout) {
        this.getChangesetEnsureInitialized().retries(retries).timeout(timeout);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateRetries(int retries) {
        this.getChangesetEnsureInitialized().retries(retries);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateTimeout(long timeout) {
        this.getChangesetEnsureInitialized().timeout(timeout);
        return this;
    }

    @Override
    public UpdateJobCommandStep1.UpdateJobCommandStep2 updateTimeout(Duration timeout) {
        return this.updateTimeout(timeout.toMillis());
    }

    private io.camunda.client.protocol.rest.JobChangeset getChangesetEnsureInitialized() {
        io.camunda.client.protocol.rest.JobChangeset changeset = this.httpRequestObject.getChangeset();
        if (changeset == null) {
            changeset = new io.camunda.client.protocol.rest.JobChangeset();
            this.httpRequestObject.setChangeset(changeset);
        }
        return changeset;
    }
}

