/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.client.impl.util.ParseUtil;
import io.camunda.client.protocol.rest.EvaluatedDecisionInputItem;
import io.camunda.client.protocol.rest.EvaluatedDecisionResult;
import io.camunda.client.protocol.rest.MatchedDecisionRuleItem;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluatedDecision;
import io.camunda.zeebe.client.api.response.EvaluatedDecisionInput;
import io.camunda.zeebe.client.api.response.MatchedDecisionRule;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionInputImpl;
import io.camunda.zeebe.client.impl.response.MatchedDecisionRuleImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EvaluatedDecisionImpl
implements EvaluatedDecision {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final String decisionId;
    private final long decisionKey;
    private final int decisionVersion;
    private final String decisionName;
    private final String decisionType;
    private final String decisionOutput;
    private final List<MatchedDecisionRule> matchedRules = new ArrayList<MatchedDecisionRule>();
    private final List<EvaluatedDecisionInput> evaluatedInputs = new ArrayList<EvaluatedDecisionInput>();
    private final String tenantId;

    public EvaluatedDecisionImpl(EvaluatedDecisionResult evaluatedDecisionItem, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.decisionId = evaluatedDecisionItem.getDecisionDefinitionId();
        this.decisionKey = ParseUtil.parseLongOrEmpty(evaluatedDecisionItem.getDecisionDefinitionKey());
        this.decisionVersion = evaluatedDecisionItem.getDecisionDefinitionVersion();
        this.decisionName = evaluatedDecisionItem.getDecisionDefinitionName();
        this.decisionType = evaluatedDecisionItem.getDecisionDefinitionType();
        this.decisionOutput = evaluatedDecisionItem.getOutput();
        this.tenantId = evaluatedDecisionItem.getTenantId();
        this.buildMatchedRules(evaluatedDecisionItem);
        this.buildEvaluatedDecisionInput(evaluatedDecisionItem);
    }

    public EvaluatedDecisionImpl(JsonMapper jsonMapper, GatewayOuterClass.EvaluatedDecision evaluatedDecision) {
        this.jsonMapper = jsonMapper;
        this.decisionId = evaluatedDecision.getDecisionId();
        this.decisionKey = evaluatedDecision.getDecisionKey();
        this.decisionName = evaluatedDecision.getDecisionName();
        this.decisionVersion = evaluatedDecision.getDecisionVersion();
        this.decisionType = evaluatedDecision.getDecisionType();
        this.decisionOutput = evaluatedDecision.getDecisionOutput();
        this.tenantId = evaluatedDecision.getTenantId();
        evaluatedDecision.getEvaluatedInputsList().stream().map(evaluatedInput -> new EvaluatedDecisionInputImpl(jsonMapper, (GatewayOuterClass.EvaluatedDecisionInput)evaluatedInput)).forEach(this.evaluatedInputs::add);
        evaluatedDecision.getMatchedRulesList().stream().map(matchedRule -> new MatchedDecisionRuleImpl(jsonMapper, (GatewayOuterClass.MatchedDecisionRule)matchedRule)).forEach(this.matchedRules::add);
    }

    private void buildEvaluatedDecisionInput(EvaluatedDecisionResult evaluatedDecisionItem) {
        if (evaluatedDecisionItem.getEvaluatedInputs() == null) {
            return;
        }
        this.evaluatedInputs.addAll(evaluatedDecisionItem.getEvaluatedInputs().stream().map(input -> new EvaluatedDecisionInputImpl((EvaluatedDecisionInputItem)input, this.jsonMapper)).collect(Collectors.toList()));
    }

    private void buildMatchedRules(EvaluatedDecisionResult evaluatedDecisionItem) {
        if (evaluatedDecisionItem.getMatchedRules() == null) {
            return;
        }
        this.matchedRules.addAll(evaluatedDecisionItem.getMatchedRules().stream().map(rule -> new MatchedDecisionRuleImpl((MatchedDecisionRuleItem)rule, this.jsonMapper)).collect(Collectors.toList()));
    }

    @Override
    public String getDecisionId() {
        return this.decisionId;
    }

    @Override
    public int getDecisionVersion() {
        return this.decisionVersion;
    }

    @Override
    public long getDecisionKey() {
        return this.decisionKey;
    }

    @Override
    public String getDecisionName() {
        return this.decisionName;
    }

    @Override
    public String getDecisionType() {
        return this.decisionType;
    }

    @Override
    public String getDecisionOutput() {
        return this.decisionOutput;
    }

    @Override
    public List<EvaluatedDecisionInput> getEvaluatedInputs() {
        return this.evaluatedInputs;
    }

    @Override
    public List<MatchedDecisionRule> getMatchedRules() {
        return this.matchedRules;
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return this.toJson();
    }
}

