/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.client.protocol.rest.MatchedDecisionRuleItem;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.EvaluatedDecisionOutput;
import io.camunda.zeebe.client.api.response.MatchedDecisionRule;
import io.camunda.zeebe.client.impl.response.EvaluatedDecisionOutputImpl;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MatchedDecisionRuleImpl
implements MatchedDecisionRule {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final String ruleId;
    private final int ruleIndex;
    private final List<EvaluatedDecisionOutput> evaluatedOutputs = new ArrayList<EvaluatedDecisionOutput>();

    public MatchedDecisionRuleImpl(MatchedDecisionRuleItem ruleItem, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.ruleId = ruleItem.getRuleId();
        this.ruleIndex = ruleItem.getRuleIndex();
        this.buildDecisionOutput(ruleItem);
    }

    public MatchedDecisionRuleImpl(JsonMapper jsonMapper, GatewayOuterClass.MatchedDecisionRule matchedRule) {
        this.jsonMapper = jsonMapper;
        this.ruleId = matchedRule.getRuleId();
        this.ruleIndex = matchedRule.getRuleIndex();
        matchedRule.getEvaluatedOutputsList().stream().map(evaluatedOutput -> new EvaluatedDecisionOutputImpl(jsonMapper, (GatewayOuterClass.EvaluatedDecisionOutput)evaluatedOutput)).forEach(this.evaluatedOutputs::add);
    }

    private void buildDecisionOutput(MatchedDecisionRuleItem ruleItem) {
        if (ruleItem.getEvaluatedOutputs() == null) {
            return;
        }
        this.evaluatedOutputs.addAll(ruleItem.getEvaluatedOutputs().stream().map(EvaluatedDecisionOutputImpl::new).collect(Collectors.toList()));
    }

    @Override
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public int getRuleIndex() {
        return this.ruleIndex;
    }

    @Override
    public List<EvaluatedDecisionOutput> getEvaluatedOutputs() {
        return this.evaluatedOutputs;
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    public String toString() {
        return this.toJson();
    }
}

