/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl;

import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CamundaClientCloudBuilderStep1;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.ExperimentalApi;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.impl.BuilderUtils;
import io.camunda.client.impl.CamundaClientBuilderImpl;
import io.camunda.client.impl.Loggers;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.client.impl.util.AddressUtil;
import io.grpc.ClientInterceptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;

public class CamundaClientCloudBuilderImpl
implements CamundaClientCloudBuilderStep1,
CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2,
CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3,
CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4,
CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4.CamundaClientCloudBuilderStep5 {
    private static final String DEFAULT_DOMAIN = "camunda.io";
    private static final String DEFAULT_REGION = "bru-2";
    private static final String ZEEBE_DOMAIN_COMPONENT = "zeebe";
    private final CamundaClientBuilderImpl innerBuilder = new CamundaClientBuilderImpl();
    private String clusterId;
    private String clientId;
    private String clientSecret;
    private String region = "bru-2";
    private String domain = "camunda.io";

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2 withClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3 withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4 withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4.CamundaClientCloudBuilderStep5 withRegion(String region) {
        this.region = region;
        return this;
    }

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4.CamundaClientCloudBuilderStep5 withDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public CamundaClientBuilder withProperties(Properties properties) {
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::withClusterId, "camunda.client.cloud.clusterId", "zeebe.client.cloud.clusterId");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::withClientId, "camunda.client.cloud.clientId", "zeebe.client.cloud.clientId");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::withClientId, "camunda.client.cloud.secret", "zeebe.client.cloud.secret");
        BuilderUtils.applyPropertyValueIfNotNull(properties, this::withRegion, "camunda.client.cloud.region", "zeebe.client.cloud.region");
        BuilderUtils.applyPropertyValueIfNotNull(properties, value -> this.defaultJobWorkerStreamEnabled(Boolean.parseBoolean(value)), "camunda.client.worker.stream.enabled", "zeebe.client.worker.stream.enabled");
        this.innerBuilder.withProperties(properties);
        this.innerBuilder.defaultTenantId("");
        this.innerBuilder.defaultJobWorkerTenantIds(Collections.emptyList());
        return this;
    }

    @Override
    public CamundaClientBuilder applyEnvironmentVariableOverrides(boolean applyEnvironmentVariableOverrides) {
        this.innerBuilder.applyEnvironmentVariableOverrides(applyEnvironmentVariableOverrides);
        return this;
    }

    @Override
    public CamundaClientBuilder restAddress(URI restAddress) {
        this.innerBuilder.restAddress(restAddress);
        return this;
    }

    @Override
    public CamundaClientBuilder grpcAddress(URI grpcAddress) {
        this.innerBuilder.grpcAddress(grpcAddress);
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/14106")
    public CamundaClientBuilder defaultTenantId(String tenantId) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/camunda/issues/14106.");
        return this;
    }

    @Override
    @ExperimentalApi(value="https://github.com/camunda/camunda/issues/14106")
    public CamundaClientBuilder defaultJobWorkerTenantIds(List<String> tenantIds) {
        Loggers.LOGGER.debug("Multi-tenancy in Camunda 8 SaaS will be supported with https://github.com/camunda/camunda/issues/14106.");
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.innerBuilder.defaultJobWorkerMaxJobsActive(maxJobsActive);
        return this;
    }

    @Override
    public CamundaClientBuilder numJobWorkerExecutionThreads(int numThreads) {
        this.innerBuilder.numJobWorkerExecutionThreads(numThreads);
        return this;
    }

    @Override
    public CamundaClientBuilder jobWorkerExecutor(ScheduledExecutorService executor, boolean takeOwnership) {
        this.innerBuilder.jobWorkerExecutor(executor, takeOwnership);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerName(String workerName) {
        this.innerBuilder.defaultJobWorkerName(workerName);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobTimeout(Duration timeout) {
        this.innerBuilder.defaultJobTimeout(timeout);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.innerBuilder.defaultJobPollInterval(pollInterval);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.innerBuilder.defaultMessageTimeToLive(timeToLive);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.innerBuilder.defaultRequestTimeout(requestTimeout);
        return this;
    }

    @Override
    public CamundaClientBuilder defaultRequestTimeoutOffset(Duration requestTimeoutOffset) {
        this.innerBuilder.defaultRequestTimeoutOffset(requestTimeoutOffset);
        return this;
    }

    @Override
    public CamundaClientBuilder caCertificatePath(String certificatePath) {
        this.innerBuilder.caCertificatePath(certificatePath);
        return this;
    }

    @Override
    public CamundaClientBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
        this.innerBuilder.credentialsProvider(credentialsProvider);
        return this;
    }

    @Override
    public CamundaClientBuilder keepAlive(Duration keepAlive) {
        this.innerBuilder.keepAlive(keepAlive);
        return this;
    }

    @Override
    public CamundaClientBuilder withInterceptors(ClientInterceptor ... interceptor) {
        this.innerBuilder.withInterceptors(interceptor);
        return this;
    }

    @Override
    public CamundaClientCloudBuilderStep1.CamundaClientCloudBuilderStep2.CamundaClientCloudBuilderStep3.CamundaClientCloudBuilderStep4 withChainHandlers(AsyncExecChainHandler ... chainHandler) {
        this.innerBuilder.withChainHandlers(chainHandler);
        return this;
    }

    @Override
    public CamundaClientBuilder withJsonMapper(JsonMapper jsonMapper) {
        this.innerBuilder.withJsonMapper(jsonMapper);
        return this;
    }

    @Override
    public CamundaClientBuilder overrideAuthority(String authority) {
        this.innerBuilder.overrideAuthority(authority);
        return this;
    }

    @Override
    public CamundaClientBuilder maxMessageSize(int maxMessageSize) {
        this.innerBuilder.maxMessageSize(maxMessageSize);
        return this;
    }

    @Override
    public CamundaClientBuilder maxMetadataSize(int maxMetadataSize) {
        return this.innerBuilder.maxMetadataSize(maxMetadataSize);
    }

    @Override
    public CamundaClientBuilder defaultJobWorkerStreamEnabled(boolean streamEnabled) {
        this.innerBuilder.defaultJobWorkerStreamEnabled(streamEnabled);
        return this;
    }

    @Override
    public CamundaClientBuilder useDefaultRetryPolicy(boolean useDefaultRetryPolicy) {
        this.innerBuilder.useDefaultRetryPolicy(useDefaultRetryPolicy);
        return this;
    }

    @Override
    public CamundaClientBuilder preferRestOverGrpc(boolean preferRestOverGrpc) {
        this.innerBuilder.preferRestOverGrpc(preferRestOverGrpc);
        return this;
    }

    @Override
    public CamundaClient build() {
        this.innerBuilder.grpcAddress(this.determineGrpcAddress());
        this.innerBuilder.restAddress(this.determineRestAddress());
        this.innerBuilder.credentialsProvider(this.determineCredentialsProvider());
        return this.innerBuilder.build();
    }

    private URI determineRestAddress() {
        if (this.isNeedToSetCloudRestAddress()) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            String cloudRestAddress = String.format("https://%s.%s.%s:443/%s", this.region, ZEEBE_DOMAIN_COMPONENT, this.domain, this.clusterId);
            return this.getURIFromString(cloudRestAddress);
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id' to set REST API address in the client cloud builder, but overwriting with explicitly defined REST API address: {}.", (Object)this.innerBuilder.getRestAddress());
        return this.innerBuilder.getRestAddress();
    }

    private URI determineGrpcAddress() {
        if (this.isNeedToSetCloudGrpcAddress()) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            String cloudGrpcAddress = String.format("https://%s.%s.%s.%s:443", this.clusterId, this.region, ZEEBE_DOMAIN_COMPONENT, this.domain);
            return this.getURIFromString(cloudGrpcAddress);
        }
        if (!this.isNeedToSetCloudGrpcAddress()) {
            Loggers.LOGGER.debug("Expected to use 'cluster id' to set gateway address in the client cloud builder, but overwriting with explicitly defined gateway address: {}.", (Object)this.innerBuilder.getGrpcAddress());
            return this.innerBuilder.getGrpcAddress();
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id' to set grpc address in the client cloud builder, but overwriting with explicitly defined grpc address: {}.", (Object)this.innerBuilder.getGrpcAddress());
        return this.innerBuilder.getGrpcAddress();
    }

    private CredentialsProvider determineCredentialsProvider() {
        CredentialsProvider provider = this.innerBuilder.getCredentialsProvider();
        if (provider == null) {
            ArgumentUtil.ensureNotNull("cluster id", this.clusterId);
            ArgumentUtil.ensureNotNull("client id", this.clientId);
            ArgumentUtil.ensureNotNull("client secret", this.clientSecret);
            OAuthCredentialsProviderBuilder builder = new OAuthCredentialsProviderBuilder();
            if (AddressUtil.isPlaintextConnection(this.innerBuilder.getGrpcAddress()) || AddressUtil.isPlaintextConnection(this.innerBuilder.getRestAddress())) {
                Loggers.LOGGER.debug("Expected a secured protocol {} for gRPC and REST, but got {} and {}.", new Object[]{AddressUtil.ENCRYPTED_SCHEMES, this.innerBuilder.getGrpcAddress(), this.innerBuilder.getRestAddress()});
            }
            return builder.audience(String.format("%s.%s", ZEEBE_DOMAIN_COMPONENT, this.domain)).clientId(this.clientId).clientSecret(this.clientSecret).authorizationServerUrl(String.format("https://login.cloud.%s/oauth/token", this.domain)).build();
        }
        Loggers.LOGGER.debug("Expected to use 'cluster id', 'client id' and 'client secret' to set credentials provider in the client cloud builder, but overwriting with explicitly defined credentials provider.");
        return provider;
    }

    private boolean isNeedToSetCloudGrpcAddress() {
        return this.innerBuilder.getGrpcAddress() == null || Objects.equals(this.innerBuilder.getGrpcAddress(), CamundaClientBuilderImpl.DEFAULT_GRPC_ADDRESS);
    }

    private boolean isNeedToSetCloudRestAddress() {
        return this.innerBuilder.getRestAddress() == null || Objects.equals(this.innerBuilder.getRestAddress(), CamundaClientBuilderImpl.DEFAULT_REST_ADDRESS);
    }

    private URI getURIFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse URI string", e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.innerBuilder.toString());
        BuilderUtils.appendProperty(sb, "clusterId", this.clusterId);
        BuilderUtils.appendProperty(sb, "clientId", this.clientId);
        BuilderUtils.appendProperty(sb, "region", this.region);
        return sb.toString();
    }
}

