/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.http;

import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.ProblemDetail;
import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.command.ClientHttpException;
import io.camunda.client.api.command.MalformedResponseException;
import io.camunda.client.api.command.ProblemException;
import io.camunda.client.impl.HttpStatusCode;
import io.camunda.client.impl.http.ApiEntity;
import io.camunda.client.impl.http.ApiResponseConsumer;
import io.camunda.client.impl.http.JsonResponseAndStatusCodeTransformer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.hc.core5.concurrent.FutureCallback;

final class ApiCallback<HttpT, RespT>
implements FutureCallback<ApiResponseConsumer.ApiResponse<HttpT>> {
    private static final Predicate<Integer> DEFAULT_SUCCESS_PREDICATE = code -> code >= 200 && code < 400;
    private final CompletableFuture<RespT> response;
    private final JsonResponseAndStatusCodeTransformer<HttpT, RespT> transformer;
    private final Predicate<Integer> successPredicate;
    private final Predicate<CredentialsProvider.StatusCode> retryPredicate;
    private final Runnable retryAction;
    private final AtomicInteger remainingRetries;

    public ApiCallback(CompletableFuture<RespT> response, JsonResponseAndStatusCodeTransformer<HttpT, RespT> transformer, Predicate<Integer> successPredicate, Predicate<CredentialsProvider.StatusCode> retryPredicate, Runnable retryAction, int maxRetries) {
        this.response = response;
        this.transformer = transformer;
        this.successPredicate = successPredicate != null ? successPredicate : DEFAULT_SUCCESS_PREDICATE;
        this.retryPredicate = retryPredicate;
        this.retryAction = retryAction;
        this.remainingRetries = new AtomicInteger(maxRetries);
    }

    public void completed(ApiResponseConsumer.ApiResponse<HttpT> result) {
        ApiEntity<HttpT> body = result.entity();
        int code = result.getCode();
        String reason = result.getReasonPhrase();
        if (this.wasSuccessful(code)) {
            this.handleSuccessResponse(body, code, reason);
            return;
        }
        this.handleErrorResponse(body, code, reason);
    }

    public void failed(Exception ex) {
        if (ex instanceof ClientException) {
            this.response.completeExceptionally(ex);
            return;
        }
        this.response.completeExceptionally(new ClientException(ex));
    }

    public void cancelled() {
        this.response.cancel(true);
    }

    private void handleErrorResponse(ApiEntity<HttpT> body, int code, String reason) {
        if (this.remainingRetries.getAndDecrement() > 0 && this.retryPredicate.test(new HttpStatusCode(code))) {
            this.retryAction.run();
            return;
        }
        if (body == null) {
            this.response.completeExceptionally(new ClientHttpException(code, reason));
            return;
        }
        if (body.isUnknown()) {
            this.response.completeExceptionally(new MalformedResponseException(String.format("Expected to receive a problem body, but got an unknown body type: %s", StandardCharsets.UTF_8.decode(body.unknown())), code, reason));
            return;
        }
        if (body.isResponse()) {
            this.response.completeExceptionally(new MalformedResponseException(String.format("Expected to receive a problem body, but got an actual response: %s", body.response()), code, reason));
            return;
        }
        ProblemDetail problem = new ProblemDetail();
        if (body.problem() != null) {
            problem.setDetail(body.problem().getDetail()).setInstance(body.problem().getInstance()).setStatus(body.problem().getStatus()).setTitle(body.problem().getTitle()).setType(body.problem().getType());
        }
        this.response.completeExceptionally(new ProblemException(code, reason, problem));
    }

    private void handleSuccessResponse(ApiEntity<HttpT> body, int code, String reason) {
        if (body == null) {
            this.completeResponse(code, reason, null);
            return;
        }
        if (body.isUnknown()) {
            this.response.completeExceptionally(new MalformedResponseException(String.format("Expected to receive a response body, but got an unknown body type: %s", StandardCharsets.UTF_8.decode(body.unknown())), code, reason));
            return;
        }
        if (body.isProblem()) {
            this.response.completeExceptionally(new MalformedResponseException(String.format("Expected to receive a response body, but got a problem: %s", body.problem()), code, reason));
            return;
        }
        this.completeResponse(code, reason, body.response());
    }

    private void completeResponse(int code, String reason, HttpT httpResponse) {
        try {
            this.response.complete(this.transformer.transform(httpResponse, code));
        }
        catch (Exception e) {
            this.response.completeExceptionally(new MalformedResponseException(code, reason, e));
        }
    }

    private boolean wasSuccessful(int code) {
        return this.successPredicate.test(code);
    }
}

