/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.RoleGroupFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.GroupsByRoleSearchRequest;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.RoleGroup;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.RoleGroupSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.RoleGroupSearchQueryRequest;
import io.camunda.client.protocol.rest.RoleGroupSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class GroupsByRoleSearchRequestImpl
extends TypedSearchRequestPropertyProvider<RoleGroupSearchQueryRequest>
implements GroupsByRoleSearchRequest {
    private final RoleGroupSearchQueryRequest request;
    private final String roleId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public GroupsByRoleSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String roleId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.roleId = roleId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleGroupSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<RoleGroup> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<RoleGroup>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<SearchResponse<RoleGroup>> result = new HttpCamundaFuture<SearchResponse<RoleGroup>>();
        this.httpClient.post(String.format("/roles/%s/groups/search", this.roleId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleGroupSearchResult.class, SearchResponseMapper::toRoleGroupsResponse, result);
        return result;
    }

    @Override
    public GroupsByRoleSearchRequest filter(RoleGroupFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public GroupsByRoleSearchRequest filter(Consumer<RoleGroupFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public GroupsByRoleSearchRequest sort(RoleGroupSort value) {
        this.request.setSort(SearchRequestSortMapper.toRoleGroupSearchQuerySortRequest((List)GroupsByRoleSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public GroupsByRoleSearchRequest sort(Consumer<RoleGroupSort> fn) {
        return this.sort(SearchRequestBuilders.roleGroupSort(fn));
    }

    @Override
    public GroupsByRoleSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)GroupsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public GroupsByRoleSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected RoleGroupSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

