/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.RoleUserFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UsersByRoleSearchRequest;
import io.camunda.client.api.search.response.RoleUser;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.RoleUserSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.RoleUserSearchQueryRequest;
import io.camunda.client.protocol.rest.RoleUserSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsersByRoleSearchRequestImpl
extends TypedSearchRequestPropertyProvider<RoleUserSearchQueryRequest>
implements UsersByRoleSearchRequest {
    private final RoleUserSearchQueryRequest request;
    private final String roleId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public UsersByRoleSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String roleId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.roleId = roleId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleUserSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<RoleUser> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<RoleUser>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<SearchResponse<RoleUser>> result = new HttpCamundaFuture<SearchResponse<RoleUser>>();
        this.httpClient.post(String.format("/roles/%s/users/search", this.roleId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleUserSearchResult.class, SearchResponseMapper::toRoleUsersResponse, result);
        return result;
    }

    @Override
    public UsersByRoleSearchRequest filter(RoleUserFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByRoleSearchRequest filter(Consumer<RoleUserFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByRoleSearchRequest sort(RoleUserSort value) {
        this.request.setSort(SearchRequestSortMapper.toRoleUserSearchQuerySortRequest((List)UsersByRoleSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UsersByRoleSearchRequest sort(Consumer<RoleUserSort> fn) {
        return this.sort(SearchRequestBuilders.roleUserSort(fn));
    }

    @Override
    public UsersByRoleSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UsersByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersByRoleSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected RoleUserSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

