/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.TenantUserFilter;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UsersByTenantSearchRequest;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.TenantUser;
import io.camunda.client.api.search.sort.TenantUserSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import io.camunda.client.protocol.rest.TenantUserSearchQueryRequest;
import io.camunda.client.protocol.rest.TenantUserSearchResult;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class UsersByTenantSearchRequestImpl
extends TypedSearchRequestPropertyProvider<TenantUserSearchQueryRequest>
implements UsersByTenantSearchRequest {
    private final TenantUserSearchQueryRequest request;
    private final String tenantId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public UsersByTenantSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String tenantId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.tenantId = tenantId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new TenantUserSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<TenantUser> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<TenantUser>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        HttpCamundaFuture<SearchResponse<TenantUser>> result = new HttpCamundaFuture<SearchResponse<TenantUser>>();
        this.httpClient.post(String.format("/tenants/%s/users/search", this.tenantId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), TenantUserSearchResult.class, SearchResponseMapper::toTenantUsersResponse, result);
        return result;
    }

    @Override
    public UsersByTenantSearchRequest filter(TenantUserFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByTenantSearchRequest filter(Consumer<TenantUserFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public UsersByTenantSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)UsersByTenantSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public UsersByTenantSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    public UsersByTenantSearchRequest sort(TenantUserSort value) {
        this.request.setSort(SearchRequestSortMapper.toTenantUserSearchQuerySortRequest((List)UsersByTenantSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public UsersByTenantSearchRequest sort(Consumer<TenantUserSort> fn) {
        return this.sort(SearchRequestBuilders.tenantUserSort(fn));
    }

    @Override
    protected TenantUserSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

