/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.util;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TagUtil {
    public static final int MAX_NUMBER_OF_TAGS = 10;
    public static final int MAX_TAG_LENGTH = 100;
    public static final String TAG_FORMAT_DESCRIPTION = String.format("Tags must start with a letter (a-z, A-Z), followed by alphanumerics, underscores, minuses, colons, or periods. It must not be blank and must be %s characters or less.", 100);
    private static final Pattern VALID_TAG_PATTERN = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_\\-:.]*$");

    public static boolean isValidTag(String tag) {
        return tag != null && tag.length() <= 100 && VALID_TAG_PATTERN.matcher(tag).matches();
    }

    public static void ensureValidTags(String context, Set<String> tags) {
        if (tags == null || tags.isEmpty()) {
            return;
        }
        if (tags.size() > 10) {
            throw new IllegalArgumentException(context + ": Tags must not contain more than " + 10 + " tags, but found " + tags.size());
        }
        List invalidTags = tags.stream().filter(tag -> !TagUtil.isValidTag(tag)).collect(Collectors.toList());
        if (!invalidTags.isEmpty()) {
            throw new IllegalArgumentException(context + ": " + TAG_FORMAT_DESCRIPTION + ". Invalid tags: " + invalidTags.stream().collect(Collectors.joining("', '")) + "'");
        }
    }
}

