/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"dueDate", "followUpDate", "candidateUsers", "candidateGroups", "priority"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Changeset
extends HashMap<String, Object> {
    public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
    @Nullable
    private String dueDate;
    public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
    @Nullable
    private String followUpDate;
    public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
    @Nullable
    private List<String> candidateUsers;
    public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
    @Nullable
    private List<String> candidateGroups;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    @Nullable
    private Integer priority = 50;

    public Changeset dueDate(@Nullable String dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDueDate() {
        return this.dueDate;
    }

    @JsonProperty(value="dueDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDueDate(@Nullable String dueDate) {
        this.dueDate = dueDate;
    }

    public Changeset followUpDate(@Nullable String followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="followUpDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFollowUpDate() {
        return this.followUpDate;
    }

    @JsonProperty(value="followUpDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFollowUpDate(@Nullable String followUpDate) {
        this.followUpDate = followUpDate;
    }

    public Changeset candidateUsers(@Nullable List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public Changeset addCandidateUsersItem(String candidateUsersItem) {
        if (this.candidateUsers == null) {
            this.candidateUsers = new ArrayList<String>();
        }
        this.candidateUsers.add(candidateUsersItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCandidateUsers() {
        return this.candidateUsers;
    }

    @JsonProperty(value="candidateUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateUsers(@Nullable List<String> candidateUsers) {
        this.candidateUsers = candidateUsers;
    }

    public Changeset candidateGroups(@Nullable List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public Changeset addCandidateGroupsItem(String candidateGroupsItem) {
        if (this.candidateGroups == null) {
            this.candidateGroups = new ArrayList<String>();
        }
        this.candidateGroups.add(candidateGroupsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="candidateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCandidateGroups() {
        return this.candidateGroups;
    }

    @JsonProperty(value="candidateGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCandidateGroups(@Nullable List<String> candidateGroups) {
        this.candidateGroups = candidateGroups;
    }

    public Changeset priority(@Nullable Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(@Nullable Integer priority) {
        this.priority = priority;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)o;
        return Objects.equals(this.dueDate, changeset.dueDate) && Objects.equals(this.followUpDate, changeset.followUpDate) && Objects.equals(this.candidateUsers, changeset.candidateUsers) && Objects.equals(this.candidateGroups, changeset.candidateGroups) && Objects.equals(this.priority, changeset.priority) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dueDate, this.followUpDate, this.candidateUsers, this.candidateGroups, this.priority, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Changeset {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    followUpDate: ").append(this.toIndentedString(this.followUpDate)).append("\n");
        sb.append("    candidateUsers: ").append(this.toIndentedString(this.candidateUsers)).append("\n");
        sb.append("    candidateGroups: ").append(this.toIndentedString(this.candidateGroups)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getDueDate() != null) {
            try {
                joiner.add(String.format("%sdueDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDueDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getFollowUpDate() != null) {
            try {
                joiner.add(String.format("%sfollowUpDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getFollowUpDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCandidateUsers() != null) {
            for (i = 0; i < this.getCandidateUsers().size(); ++i) {
                try {
                    joiner.add(String.format("%scandidateUsers%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCandidateUsers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getCandidateGroups() != null) {
            for (i = 0; i < this.getCandidateGroups().size(); ++i) {
                try {
                    joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix), URLEncoder.encode(String.valueOf(this.getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getPriority() != null) {
            try {
                joiner.add(String.format("%spriority%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPriority()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

