/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.shared.EnvironmentHelper;
import io.camunda.zeebe.util.FileUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;

@SpringBootApplication(exclude={ElasticsearchRestClientAutoConfiguration.class})
@ComponentScan(value={"io.camunda.zeebe.broker", "io.camunda.zeebe.shared"})
public class StandaloneBroker
implements CommandLineRunner {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    @Autowired
    BrokerCfg configuration;
    @Autowired
    Environment springEnvironment;
    @Autowired
    SpringBrokerBridge springBrokerBridge;
    private final CountDownLatch waiting_latch = new CountDownLatch(1);
    private String tempFolder;

    public static void main(String[] args) throws Exception {
        System.setProperty("spring.banner.location", "classpath:/assets/zeebe_broker_banner.txt");
        EnvironmentHelper.disableGatewayHealthIndicatorsAndProbes();
        SpringApplication.run(StandaloneBroker.class, (String[])args);
    }

    public void run(String ... args) throws Exception {
        final Broker broker = EnvironmentHelper.isProductionEnvironment(this.springEnvironment) ? this.createBrokerInBaseDirectory() : this.createBrokerInTempDirectory();
        broker.start();
        Runtime.getRuntime().addShutdownHook(new Thread("Broker close Thread"){

            @Override
            public void run() {
                try {
                    broker.close();
                }
                finally {
                    StandaloneBroker.this.deleteTempDirectory();
                    LogManager.shutdown();
                }
            }
        });
        this.waiting_latch.await();
    }

    private Broker createBrokerInBaseDirectory() {
        String basePath = System.getProperty("basedir");
        if (basePath == null) {
            basePath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        }
        return new Broker(this.configuration, basePath, null, this.springBrokerBridge);
    }

    private Broker createBrokerInTempDirectory() {
        Loggers.SYSTEM_LOGGER.info("Launching broker in temporary folder.");
        try {
            this.tempFolder = Files.createTempDirectory("zeebe", new FileAttribute[0]).toAbsolutePath().normalize().toString();
            return new Broker(this.configuration, this.tempFolder, null, this.springBrokerBridge);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not start broker", e);
        }
    }

    private void deleteTempDirectory() {
        if (this.tempFolder != null) {
            try {
                FileUtil.deleteFolder((String)this.tempFolder);
            }
            catch (IOException e) {
                LOG.error("Failed to delete temporary folder {}", (Object)this.tempFolder, (Object)e);
            }
        }
    }
}

