/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.cluster.protocol.GroupMembershipProtocol;
import io.atomix.cluster.protocol.SwimMembershipProtocol;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.SpringGatewayBridge;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.configuration.ClusterCfg;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.sched.ActorScheduler;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchRestClientAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

public class StandaloneGateway {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final AtomixCluster atomixCluster;
    private final Gateway gateway;
    private final ActorScheduler actorScheduler;

    public StandaloneGateway(GatewayCfg gatewayCfg, SpringGatewayBridge springGatewayBridge) {
        this.atomixCluster = this.createAtomixCluster(gatewayCfg.getCluster());
        this.actorScheduler = this.createActorScheduler(gatewayCfg);
        Function<GatewayCfg, BrokerClient> brokerClientFactory = cfg -> new BrokerClientImpl(cfg, this.atomixCluster.getMessagingService(), this.atomixCluster.getMembershipService(), this.atomixCluster.getEventService(), this.actorScheduler, false);
        this.gateway = new Gateway(gatewayCfg, brokerClientFactory, this.actorScheduler);
        springGatewayBridge.registerGatewayStatusSupplier(() -> ((Gateway)this.gateway).getStatus());
        springGatewayBridge.registerClusterStateSupplier(() -> Optional.ofNullable(this.gateway.getBrokerClient()).map(BrokerClient::getTopologyManager).map(BrokerTopologyManager::getTopology));
    }

    private AtomixCluster createAtomixCluster(ClusterCfg clusterCfg) {
        MembershipCfg membershipCfg = clusterCfg.getMembership();
        GroupMembershipProtocol membershipProtocol = SwimMembershipProtocol.builder().withFailureTimeout(membershipCfg.getFailureTimeout()).withGossipInterval(membershipCfg.getGossipInterval()).withProbeInterval(membershipCfg.getProbeInterval()).withProbeTimeout(membershipCfg.getProbeTimeout()).withBroadcastDisputes(membershipCfg.isBroadcastDisputes()).withBroadcastUpdates(membershipCfg.isBroadcastUpdates()).withGossipFanout(membershipCfg.getGossipFanout()).withNotifySuspect(membershipCfg.isNotifySuspect()).withSuspectProbes(membershipCfg.getSuspectProbes()).withSyncInterval(membershipCfg.getSyncInterval()).build();
        AtomixCluster atomix = AtomixCluster.builder().withMemberId(clusterCfg.getMemberId()).withAddress(Address.from((String)clusterCfg.getHost(), (int)clusterCfg.getPort())).withClusterId(clusterCfg.getClusterName()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(new Address[]{Address.from((String)clusterCfg.getContactPoint())}).build()).withMembershipProtocol(membershipProtocol).build();
        atomix.start();
        return atomix;
    }

    private ActorScheduler createActorScheduler(GatewayCfg configuration) {
        ActorScheduler actorScheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(configuration.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setSchedulerName("gateway-scheduler").build();
        actorScheduler.start();
        return actorScheduler;
    }

    public void run() throws IOException, InterruptedException {
        this.gateway.listenAndServe();
        this.atomixCluster.stop();
        this.actorScheduler.stop();
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("spring.banner.location", "classpath:/assets/zeebe_gateway_banner.txt");
        Runtime.getRuntime().addShutdownHook(new Thread("Gateway close thread"){

            @Override
            public void run() {
                LogManager.shutdown();
            }
        });
        SpringApplication.run(Launcher.class, (String[])args);
    }

    @SpringBootApplication(exclude={ElasticsearchRestClientAutoConfiguration.class})
    @ComponentScan(value={"io.camunda.zeebe.gateway", "io.camunda.zeebe.shared", "io.camunda.zeebe.util"})
    public static class Launcher
    implements CommandLineRunner {
        @Autowired
        GatewayCfg configuration;
        @Autowired
        SpringGatewayBridge springGatewayBridge;

        public void run(String ... args) throws Exception {
            GatewayCfg gatewayCfg = this.configuration;
            gatewayCfg.init();
            if (LOG.isInfoEnabled()) {
                LOG.info("Version: {}", (Object)VersionUtil.getVersion());
                LOG.info("Starting standalone gateway with configuration {}", (Object)gatewayCfg.toJson());
            }
            new StandaloneGateway(gatewayCfg, this.springGatewayBridge).run();
        }
    }
}

