/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched;

import io.camunda.zeebe.util.sched.ActorJob;
import io.camunda.zeebe.util.sched.ActorSubscription;
import io.camunda.zeebe.util.sched.ActorTask;
import io.camunda.zeebe.util.sched.ActorThread;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import java.util.concurrent.TimeUnit;

public final class TimerSubscription
implements ActorSubscription,
ScheduledTimer,
Runnable {
    private final ActorJob job;
    private final ActorTask task;
    private final TimeUnit timeUnit;
    private final long deadline;
    private final boolean isRecurring;
    private volatile boolean isDone = false;
    private volatile boolean isCanceled = false;
    private long timerId = -1L;
    private ActorThread thread;

    public TimerSubscription(ActorJob job, long deadline, TimeUnit timeUnit, boolean isRecurring) {
        this.job = job;
        this.task = job.getTask();
        this.timeUnit = timeUnit;
        this.deadline = deadline;
        this.isRecurring = isRecurring;
    }

    @Override
    public boolean poll() {
        return this.isDone;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return this.isRecurring;
    }

    @Override
    public void onJobCompleted() {
        if (this.isRecurring && !this.isCanceled) {
            this.isDone = false;
            this.submit();
        }
    }

    @Override
    public void cancel() {
        if (!(this.isCanceled || this.isDone && !this.isRecurring)) {
            this.task.onSubscriptionCancelled(this);
            this.isCanceled = true;
            ActorThread current = ActorThread.current();
            if (current != this.thread) {
                this.thread.submittedCallbacks.add((Object)this);
            } else {
                this.run();
            }
        }
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void setTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void submit() {
        this.thread = ActorThread.current();
        this.thread.scheduleTimer(this);
    }

    public long getDeadline() {
        return this.deadline;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void onTimerExpired(TimeUnit timeUnit, long now) {
        if (!this.isCanceled) {
            this.isDone = true;
            this.task.tryWakeup();
        }
    }

    @Override
    public void run() {
        this.thread.removeTimer(this);
    }

    public String toString() {
        return "TimerSubscription{timerId=" + this.timerId + ", deadline=" + this.deadline + ", timeUnit=" + this.timeUnit + ", isRecurring=" + this.isRecurring + ", isDone=" + this.isDone + ", isCanceled=" + this.isCanceled + ", thread=" + this.thread + "}";
    }
}

