/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.camunda.zeebe.dispatcher.BlockPeek;
import io.camunda.zeebe.dispatcher.Subscription;
import io.camunda.zeebe.logstreams.impl.Loggers;
import io.camunda.zeebe.logstreams.impl.backpressure.AlgorithmCfg;
import io.camunda.zeebe.logstreams.impl.backpressure.AppendBackpressureMetrics;
import io.camunda.zeebe.logstreams.impl.backpressure.AppendEntryLimiter;
import io.camunda.zeebe.logstreams.impl.backpressure.AppendLimiter;
import io.camunda.zeebe.logstreams.impl.backpressure.AppenderGradient2Cfg;
import io.camunda.zeebe.logstreams.impl.backpressure.AppenderVegasCfg;
import io.camunda.zeebe.logstreams.impl.backpressure.NoopAppendLimiter;
import io.camunda.zeebe.logstreams.impl.log.AppenderMetrics;
import io.camunda.zeebe.logstreams.impl.log.Listener;
import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.util.Environment;
import io.camunda.zeebe.util.collection.Tuple;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.channel.ConsumableChannel;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.camunda.zeebe.util.sched.future.CompletableActorFuture;
import io.prometheus.client.Histogram;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class LogStorageAppender
extends Actor
implements HealthMonitorable {
    public static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private static final Map<String, AlgorithmCfg> ALGORITHM_CFG = Map.of("vegas", new AppenderVegasCfg(), "gradient2", new AppenderGradient2Cfg());
    private final String name;
    private final Subscription writeBufferSubscription;
    private final int maxAppendBlockSize;
    private final LogStorage logStorage;
    private final AppendLimiter appendEntryLimiter;
    private final AppendBackpressureMetrics appendBackpressureMetrics;
    private final Environment env;
    private final LoggedEventImpl positionReader = new LoggedEventImpl();
    private final AppenderMetrics appenderMetrics;
    private final Set<FailureListener> failureListeners = new HashSet<FailureListener>();
    private final ActorFuture<Void> closeFuture;
    private final int partitionId;

    public LogStorageAppender(String name, int partitionId, LogStorage logStorage, Subscription writeBufferSubscription, int maxBlockSize) {
        this.appenderMetrics = new AppenderMetrics(Integer.toString(partitionId));
        this.env = new Environment();
        this.name = name;
        this.partitionId = partitionId;
        this.logStorage = logStorage;
        this.writeBufferSubscription = writeBufferSubscription;
        this.maxAppendBlockSize = maxBlockSize;
        this.appendBackpressureMetrics = new AppendBackpressureMetrics(partitionId);
        boolean isBackpressureEnabled = this.env.getBool("ZEEBE_BP_APPENDER").orElse(true);
        this.appendEntryLimiter = isBackpressureEnabled ? this.initBackpressure(partitionId) : this.initNoBackpressure(partitionId);
        this.closeFuture = new CompletableActorFuture();
    }

    private AppendLimiter initBackpressure(int partitionId) {
        String algorithmName = this.env.get("ZEEBE_BP_APPENDER_ALGORITHM").orElse("vegas").toLowerCase();
        AlgorithmCfg algorithmCfg = ALGORITHM_CFG.getOrDefault(algorithmName, new AppenderVegasCfg());
        algorithmCfg.applyEnvironment(this.env);
        AbstractLimit abstractLimit = (AbstractLimit)algorithmCfg.get();
        boolean windowedLimiter = this.env.getBool("ZEEBE_BP_APPENDER_WINDOWED").orElse(false);
        LOG.debug("Configured log appender back pressure at partition {} as {}. Window limiting is {}", new Object[]{partitionId, algorithmCfg, windowedLimiter ? "enabled" : "disabled"});
        return ((AppendEntryLimiter.AppendEntryLimiterBuilder)AppendEntryLimiter.builder().limit((Limit)(windowedLimiter ? WindowedLimit.newBuilder().build((Limit)abstractLimit) : abstractLimit))).partitionId(partitionId).build();
    }

    private AppendLimiter initNoBackpressure(int partition) {
        LOG.warn("No back pressure for the log appender (partition = {}) configured! This might cause problems.", (Object)partition);
        return new NoopAppendLimiter();
    }

    private boolean appendBlock(BlockPeek blockPeek) {
        ByteBuffer rawBuffer = blockPeek.getRawBuffer();
        int bytes = rawBuffer.remaining();
        ByteBuffer copiedBuffer = ByteBuffer.allocate(bytes).put(rawBuffer).flip();
        Tuple<Long, Long> positions = this.readLowestHighestPosition(copiedBuffer);
        this.appendBackpressureMetrics.newEntryToAppend();
        if (this.appendEntryLimiter.tryAcquire((Long)positions.getRight())) {
            Listener listener = new Listener(this, (Long)positions.getRight(), this.appenderMetrics.startAppendLatencyTimer(), this.appenderMetrics.startCommitLatencyTimer());
            this.logStorage.append((Long)positions.getLeft(), (Long)positions.getRight(), copiedBuffer, listener);
            blockPeek.markCompleted();
            return true;
        }
        this.appendBackpressureMetrics.deferred();
        LOG.trace("Backpressure happens: in flight {} limit {}", (Object)this.appendEntryLimiter.getInflight(), (Object)this.appendEntryLimiter.getLimit());
        return false;
    }

    protected Map<String, String> createContext() {
        Map context = super.createContext();
        context.put("partitionId", Integer.toString(this.partitionId));
        return context;
    }

    public String getName() {
        return this.name;
    }

    protected void onActorStarting() {
        this.actor.consume((ConsumableChannel)this.writeBufferSubscription, this::onWriteBufferAvailable);
    }

    protected void onActorClosed() {
        this.closeFuture.complete(null);
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return this.closeFuture;
        }
        super.closeAsync();
        return this.closeFuture;
    }

    protected void handleFailure(Throwable failure) {
        this.onFailure(failure);
    }

    public void onActorFailed() {
        this.closeFuture.complete(null);
    }

    private void onWriteBufferAvailable() {
        BlockPeek blockPeek = new BlockPeek();
        int readBytes = this.writeBufferSubscription.peekBlock(blockPeek, this.maxAppendBlockSize, true);
        boolean canAppend = readBytes > 0;
        boolean appendBlockSucceeded = false;
        if (canAppend) {
            appendBlockSucceeded = this.appendBlock(blockPeek);
        }
        if (!canAppend || !appendBlockSucceeded) {
            this.actor.yieldThread();
        }
    }

    private Tuple<Long, Long> readLowestHighestPosition(ByteBuffer buffer) {
        UnsafeBuffer view = new UnsafeBuffer(buffer);
        Tuple positions = new Tuple((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE);
        int offset = 0;
        do {
            this.positionReader.wrap((DirectBuffer)view, offset);
            long pos = this.positionReader.getPosition();
            positions.setLeft((Object)Math.min((Long)positions.getLeft(), pos));
            positions.setRight((Object)Math.max((Long)positions.getRight(), pos));
        } while ((offset += this.positionReader.getLength()) < view.capacity());
        return positions;
    }

    public HealthStatus getHealthStatus() {
        return this.actor.isClosed() ? HealthStatus.UNHEALTHY : HealthStatus.HEALTHY;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.add(failureListener));
    }

    public void removeFailureListener(FailureListener failureListener) {
        this.actor.run(() -> this.failureListeners.remove(failureListener));
    }

    private void onFailure(Throwable error) {
        LOG.error("Actor {} failed in phase {}.", new Object[]{this.name, this.actor.getLifecyclePhase(), error});
        this.actor.fail();
        this.failureListeners.forEach(FailureListener::onFailure);
    }

    void runOnFailure(Throwable error) {
        this.actor.run(() -> this.onFailure(error));
    }

    void releaseBackPressure(long highestPosition) {
        this.actor.run(() -> this.appendEntryLimiter.onCommit(highestPosition));
    }

    void notifyWritePosition(long highestPosition, Histogram.Timer appendLatencyTimer) {
        this.actor.run(() -> {
            this.appenderMetrics.setLastAppendedPosition(highestPosition);
            appendLatencyTimer.close();
        });
    }

    void notifyCommitPosition(long highestPosition, Histogram.Timer commitLatencyTimer) {
        this.actor.run(() -> {
            this.appenderMetrics.setLastCommittedPosition(highestPosition);
            commitLatencyTimer.close();
        });
    }
}

