/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.cluster.messaging.MessagingService;
import io.camunda.zeebe.gateway.EndpointManager;
import io.camunda.zeebe.gateway.GatewayGrpcService;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.NetworkCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.camunda.zeebe.gateway.impl.job.LongPollingActivateJobsHandler;
import io.camunda.zeebe.gateway.impl.job.RoundRobinActivateJobsHandler;
import io.camunda.zeebe.gateway.interceptors.impl.ContextInjectingInterceptor;
import io.camunda.zeebe.gateway.interceptors.impl.DecoratedInterceptor;
import io.camunda.zeebe.gateway.interceptors.impl.InterceptorRepository;
import io.camunda.zeebe.gateway.query.impl.QueryApiImpl;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ActorSchedulingService;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.MonitoringServerInterceptor;
import org.slf4j.Logger;

public final class Gateway {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private static final Function<GatewayCfg, ServerBuilder> DEFAULT_SERVER_BUILDER_FACTORY = cfg -> Gateway.setNetworkConfig(cfg.getNetwork());
    private final Function<GatewayCfg, ServerBuilder> serverBuilderFactory;
    private final Function<GatewayCfg, BrokerClient> brokerClientFactory;
    private final GatewayCfg gatewayCfg;
    private final ActorSchedulingService actorSchedulingService;
    private Server server;
    private BrokerClient brokerClient;
    private volatile Status status = Status.INITIAL;

    public Gateway(GatewayCfg gatewayCfg, MessagingService messagingService, ClusterMembershipService membershipService, ClusterEventService eventService, ActorSchedulingService actorSchedulingService) {
        this(gatewayCfg, cfg -> new BrokerClientImpl((GatewayCfg)cfg, messagingService, membershipService, eventService), DEFAULT_SERVER_BUILDER_FACTORY, actorSchedulingService);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory, ActorSchedulingService actorSchedulingService) {
        this(gatewayCfg, brokerClientFactory, DEFAULT_SERVER_BUILDER_FACTORY, actorSchedulingService);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory, Function<GatewayCfg, ServerBuilder> serverBuilderFactory, ActorSchedulingService actorSchedulingService) {
        this.gatewayCfg = gatewayCfg;
        this.brokerClientFactory = brokerClientFactory;
        this.serverBuilderFactory = serverBuilderFactory;
        this.actorSchedulingService = actorSchedulingService;
    }

    public GatewayCfg getGatewayCfg() {
        return this.gatewayCfg;
    }

    public Status getStatus() {
        return this.status;
    }

    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void start() throws IOException {
        this.status = Status.STARTING;
        this.brokerClient = this.buildBrokerClient();
        ActivateJobsHandler activateJobsHandler = this.buildActivateJobsHandler(this.brokerClient);
        this.submitActorToActivateJobs((Consumer)((Object)activateJobsHandler));
        EndpointManager endpointManager = new EndpointManager(this.brokerClient, activateJobsHandler);
        GatewayGrpcService gatewayGrpcService = new GatewayGrpcService(endpointManager);
        ServerBuilder serverBuilder = this.serverBuilderFactory.apply(this.gatewayCfg);
        SecurityCfg securityCfg = this.gatewayCfg.getSecurity();
        if (securityCfg.isEnabled()) {
            this.setSecurityConfig(serverBuilder, securityCfg);
        }
        this.server = serverBuilder.addService(this.applyInterceptors(gatewayGrpcService)).build();
        this.server.start();
        this.status = Status.RUNNING;
    }

    private static NettyServerBuilder setNetworkConfig(NetworkCfg cfg) {
        Duration minKeepAliveInterval = cfg.getMinKeepAliveInterval();
        if (minKeepAliveInterval.isNegative() || minKeepAliveInterval.isZero()) {
            throw new IllegalArgumentException("Minimum keep alive interval must be positive.");
        }
        return NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(cfg.getHost(), cfg.getPort())).permitKeepAliveTime(minKeepAliveInterval.toMillis(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(false);
    }

    private void setSecurityConfig(ServerBuilder<?> serverBuilder, SecurityCfg security) {
        if (security.getCertificateChainPath() == null) {
            throw new IllegalArgumentException("Expected to find a valid path to a certificate chain but none was found. Edit the gateway configuration file to provide one or to disable TLS.");
        }
        if (security.getPrivateKeyPath() == null) {
            throw new IllegalArgumentException("Expected to find a valid path to a private key but none was found. Edit the gateway configuration file to provide one or to disable TLS.");
        }
        File certChain = new File(security.getCertificateChainPath());
        File privateKey = new File(security.getPrivateKeyPath());
        if (!certChain.exists()) {
            throw new IllegalArgumentException(String.format("Expected to find a certificate chain file at the provided location '%s' but none was found.", security.getCertificateChainPath()));
        }
        if (!privateKey.exists()) {
            throw new IllegalArgumentException(String.format("Expected to find a private key file at the provided location '%s' but none was found.", security.getPrivateKeyPath()));
        }
        serverBuilder.useTransportSecurity(certChain, privateKey);
    }

    private BrokerClient buildBrokerClient() {
        return this.brokerClientFactory.apply(this.gatewayCfg);
    }

    private void submitActorToActivateJobs(Consumer<ActorControl> consumer) {
        CompletableFuture actorStartedFuture = new CompletableFuture();
        Actor actor = Actor.newActor().name("ActivateJobsHandler").actorStartedHandler(consumer.andThen(actorStartedFuture::complete)).build();
        this.actorSchedulingService.submitActor(actor);
        actorStartedFuture.join();
    }

    private ActivateJobsHandler buildActivateJobsHandler(BrokerClient brokerClient) {
        if (this.gatewayCfg.getLongPolling().isEnabled()) {
            return this.buildLongPollingHandler(brokerClient);
        }
        return new RoundRobinActivateJobsHandler(brokerClient);
    }

    private LongPollingActivateJobsHandler buildLongPollingHandler(BrokerClient brokerClient) {
        return LongPollingActivateJobsHandler.newBuilder().setBrokerClient(brokerClient).build();
    }

    private ServerServiceDefinition applyInterceptors(GatewayGrpcService service) {
        InterceptorRepository repository = new InterceptorRepository().load(this.gatewayCfg.getInterceptors());
        QueryApiImpl queryApi = new QueryApiImpl(this.brokerClient);
        List interceptors = repository.instantiate().map(DecoratedInterceptor::decorate).collect(Collectors.toList());
        Collections.reverse(interceptors);
        interceptors.add(new ContextInjectingInterceptor(queryApi));
        if (this.gatewayCfg.getMonitoring().isEnabled()) {
            MonitoringServerInterceptor interceptor = MonitoringServerInterceptor.create((Configuration)Configuration.allMetrics());
            interceptors.add(interceptor);
        }
        return ServerInterceptors.intercept((BindableService)service, interceptors);
    }

    public void stop() {
        this.status = Status.SHUTDOWN;
        if (this.server != null && !this.server.isShutdown()) {
            this.server.shutdownNow();
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to await termination of gateway", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            finally {
                this.server = null;
            }
        }
        if (this.brokerClient != null) {
            this.brokerClient.close();
            this.brokerClient = null;
        }
    }

    public static enum Status {
        INITIAL,
        STARTING,
        RUNNING,
        SHUTDOWN;

    }
}

