/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import com.google.rpc.Status;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.ResponseMapper;
import io.camunda.zeebe.gateway.cmd.BrokerErrorException;
import io.camunda.zeebe.gateway.cmd.BrokerRejectionException;
import io.camunda.zeebe.gateway.grpc.ServerStreamObserver;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.PartitionIdIterator;
import io.camunda.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerFailJobRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.camunda.zeebe.gateway.impl.job.InflightActivateJobsRequest;
import io.camunda.zeebe.gateway.impl.job.InflightActivateJobsRequestState;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.sched.ActorControl;
import io.grpc.protobuf.StatusProto;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class RoundRobinActivateJobsHandler
implements ActivateJobsHandler,
Consumer<ActorControl> {
    private static final String ACTIVATE_JOB_NOT_SENT_MSG = "Failed to send activated jobs to client";
    private static final String ACTIVATE_JOB_NOT_SENT_MSG_WITH_REASON = "Failed to send activated jobs to client, failed with: %s";
    private final Map<String, RequestDispatchStrategy> jobTypeToNextPartitionId = new ConcurrentHashMap<String, RequestDispatchStrategy>();
    private final BrokerClient brokerClient;
    private final BrokerTopologyManager topologyManager;
    private ActorControl actor;

    public RoundRobinActivateJobsHandler(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        this.topologyManager = brokerClient.getTopologyManager();
    }

    @Override
    public void accept(ActorControl actor) {
        this.actor = actor;
    }

    @Override
    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology != null) {
            InflightActivateJobsRequest inflightRequest = ActivateJobsHandler.toInflightActivateJobsRequest(request, responseObserver);
            this.activateJobs(topology.getPartitionsCount(), inflightRequest, arg_0 -> responseObserver.onError(arg_0), (remainingAmount, resourceExhaustedWasPresent) -> responseObserver.onCompleted());
        }
    }

    public void activateJobs(int partitionsCount, InflightActivateJobsRequest request, Consumer<Throwable> onError, BiConsumer<Integer, Boolean> onCompleted) {
        String jobType = request.getType();
        int maxJobsToActivate = request.getMaxJobsToActivate();
        PartitionIdIterator partitionIterator = this.partitionIdIteratorForType(jobType, partitionsCount);
        InflightActivateJobsRequestState requestState = new InflightActivateJobsRequestState(partitionIterator, maxJobsToActivate);
        ResponseObserverDelegate delegate = new ResponseObserverDelegate(onError, onCompleted);
        this.activateJobs(request, requestState, delegate);
    }

    private void activateJobs(InflightActivateJobsRequest request, InflightActivateJobsRequestState requestState, ResponseObserverDelegate delegate) {
        this.actor.run(() -> {
            if (!request.isOpen()) {
                return;
            }
            if (requestState.shouldActivateJobs()) {
                BrokerActivateJobsRequest brokerRequest = request.getRequest();
                int partitionId = requestState.getNextPartition();
                int remainingAmount = requestState.getRemainingAmount();
                brokerRequest.setPartitionId(partitionId);
                brokerRequest.setMaxJobsToActivate(remainingAmount);
                this.brokerClient.sendRequest(brokerRequest).whenComplete((BiConsumer)this.handleBrokerResponse(request, requestState, delegate));
            } else {
                int remainingAmount = requestState.getRemainingAmount();
                boolean resourceExhaustedWasPresent = requestState.wasResourceExhaustedPresent();
                delegate.onCompleted(remainingAmount, resourceExhaustedWasPresent);
            }
        });
    }

    private BiConsumer<BrokerResponse<JobBatchRecord>, Throwable> handleBrokerResponse(InflightActivateJobsRequest request, InflightActivateJobsRequestState requestState, ResponseObserverDelegate delegate) {
        return (brokerResponse, error) -> {
            if (error == null) {
                this.handleResponseSuccess(request, requestState, delegate, (BrokerResponse<JobBatchRecord>)brokerResponse);
            } else {
                this.handleResponseError(request, requestState, delegate, (Throwable)error);
            }
        };
    }

    private void handleResponseSuccess(InflightActivateJobsRequest request, InflightActivateJobsRequestState requestState, ResponseObserverDelegate delegate, BrokerResponse<JobBatchRecord> brokerResponse) {
        this.actor.run(() -> {
            Either<Exception, Boolean> result;
            Boolean responseWasSent;
            boolean jobsActivated;
            JobBatchRecord response = (JobBatchRecord)brokerResponse.getResponse();
            GatewayOuterClass.ActivateJobsResponse grpcResponse = ResponseMapper.toActivateJobsResponse(brokerResponse.getKey(), response);
            int jobsCount = grpcResponse.getJobsCount();
            boolean bl = jobsActivated = jobsCount > 0;
            if (jobsActivated && !(responseWasSent = (Boolean)(result = request.tryToSendActivatedJobs(grpcResponse)).getOrElse((Object)false)).booleanValue()) {
                List activatedJobsToReactivate = grpcResponse.getJobsList();
                List jobKeys = response.getJobKeys();
                String jobType = request.getType();
                String reason = this.createReasonMessage(result);
                this.logResponseNotSent(jobType, jobKeys, reason);
                this.reactivateJobs(activatedJobsToReactivate, reason);
                this.cancelActivateJobsRequest(reason, delegate);
                return;
            }
            int remainingJobsToActivate = requestState.getRemainingAmount() - jobsCount;
            boolean shouldPollCurrentPartitionAgain = response.getTruncated();
            requestState.setRemainingAmount(remainingJobsToActivate);
            requestState.setPollPrevPartition(shouldPollCurrentPartitionAgain);
            this.activateJobs(request, requestState, delegate);
        });
    }

    private String createReasonMessage(Either<Exception, Boolean> resultValue) {
        String errorMessage;
        if (resultValue.isLeft()) {
            Exception exception = (Exception)resultValue.getLeft();
            errorMessage = String.format(ACTIVATE_JOB_NOT_SENT_MSG_WITH_REASON, exception.getMessage());
        } else {
            errorMessage = ACTIVATE_JOB_NOT_SENT_MSG;
        }
        return errorMessage;
    }

    private void reactivateJobs(List<GatewayOuterClass.ActivatedJob> activateJobs, String message) {
        if (activateJobs != null) {
            activateJobs.forEach(j -> this.tryToReactivateJob((GatewayOuterClass.ActivatedJob)j, message));
        }
    }

    private void tryToReactivateJob(GatewayOuterClass.ActivatedJob job, String message) {
        BrokerFailJobRequest request = this.toFailJobRequest(job, message);
        this.brokerClient.sendRequestWithRetry(request).whenComplete((response, error) -> {
            if (error != null) {
                Loggers.GATEWAY_LOGGER.info("Failed to reactivate job {} due to {}", (Object)job.getKey(), (Object)error.getMessage());
            }
        });
    }

    private BrokerFailJobRequest toFailJobRequest(GatewayOuterClass.ActivatedJob job, String errorMessage) {
        return new BrokerFailJobRequest(job.getKey(), job.getRetries()).setErrorMessage(errorMessage);
    }

    private void cancelActivateJobsRequest(String reason, ResponseObserverDelegate delegate) {
        Status status = Status.newBuilder().setCode(1).setMessage(reason).build();
        delegate.onError((Throwable)StatusProto.toStatusException((Status)status));
    }

    private void handleResponseError(InflightActivateJobsRequest request, InflightActivateJobsRequestState state, ResponseObserverDelegate delegate, Throwable error) {
        this.actor.run(() -> {
            boolean wasResourceExhausted = this.wasResourceExhausted(error);
            if (this.isRejection(error)) {
                delegate.onError(error);
                return;
            }
            if (!wasResourceExhausted) {
                this.logErrorResponse(state.getCurrentPartition(), request.getType(), error);
            }
            state.setResourceExhaustedWasPresent(wasResourceExhausted);
            state.setPollPrevPartition(false);
            this.activateJobs(request, state, delegate);
        });
    }

    private boolean isRejection(Throwable error) {
        return error != null && BrokerRejectionException.class.isAssignableFrom(error.getClass());
    }

    private boolean wasResourceExhausted(Throwable error) {
        if (error instanceof BrokerErrorException) {
            BrokerErrorException brokerError = (BrokerErrorException)error;
            return brokerError.getError().getCode() == ErrorCode.RESOURCE_EXHAUSTED;
        }
        return false;
    }

    private void logErrorResponse(int partition, String jobType, Throwable error) {
        Loggers.GATEWAY_LOGGER.warn("Failed to activate jobs for type {} from partition {}", new Object[]{jobType, partition, error});
    }

    private void logResponseNotSent(String jobType, List<Long> jobKeys, String reason) {
        Loggers.GATEWAY_LOGGER.debug("Failed to send {} activated jobs for type {} (with job keys: {}) to client, because: {}", new Object[]{jobKeys.size(), jobType, jobKeys, reason});
    }

    private PartitionIdIterator partitionIdIteratorForType(String jobType, int partitionsCount) {
        RequestDispatchStrategy nextPartitionSupplier = this.jobTypeToNextPartitionId.computeIfAbsent(jobType, t -> new RoundRobinDispatchStrategy(this.topologyManager));
        return new PartitionIdIterator(nextPartitionSupplier.determinePartition(), partitionsCount, this.topologyManager);
    }

    private static final class ResponseObserverDelegate {
        private final Consumer<Throwable> onErrorDelegate;
        private final BiConsumer<Integer, Boolean> onCompletedDelegate;

        private ResponseObserverDelegate(Consumer<Throwable> onErrorDelegate, BiConsumer<Integer, Boolean> onCompletedDelegate) {
            this.onErrorDelegate = onErrorDelegate;
            this.onCompletedDelegate = onCompletedDelegate;
        }

        public void onError(Throwable t) {
            this.onErrorDelegate.accept(t);
        }

        public void onCompleted(int remainingAmount, boolean resourceExhaustedWasPresent) {
            this.onCompletedDelegate.accept(remainingAmount, resourceExhaustedWasPresent);
        }
    }
}

