/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.prometheus.client.CollectorRegistry;

public class Configuration {
    private static double[] DEFAULT_LATENCY_BUCKETS = new double[]{0.001, 0.005, 0.01, 0.05, 0.075, 0.1, 0.25, 0.5, 1.0, 2.0, 5.0, 10.0};
    private final boolean isIncludeLatencyHistograms;
    private final CollectorRegistry collectorRegistry;
    private final double[] latencyBuckets;

    public static Configuration cheapMetricsOnly() {
        return new Configuration(false, CollectorRegistry.defaultRegistry, DEFAULT_LATENCY_BUCKETS);
    }

    public static Configuration allMetrics() {
        return new Configuration(true, CollectorRegistry.defaultRegistry, DEFAULT_LATENCY_BUCKETS);
    }

    public Configuration withCollectorRegistry(CollectorRegistry collectorRegistry) {
        return new Configuration(this.isIncludeLatencyHistograms, collectorRegistry, this.latencyBuckets);
    }

    public Configuration withLatencyBuckets(double[] dArray) {
        return new Configuration(this.isIncludeLatencyHistograms, this.collectorRegistry, dArray);
    }

    public boolean isIncludeLatencyHistograms() {
        return this.isIncludeLatencyHistograms;
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.collectorRegistry;
    }

    public double[] getLatencyBuckets() {
        return this.latencyBuckets;
    }

    private Configuration(boolean bl, CollectorRegistry collectorRegistry, double[] dArray) {
        this.isIncludeLatencyHistograms = bl;
        this.collectorRegistry = collectorRegistry;
        this.latencyBuckets = dArray;
    }
}

