/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.MethodDescriptor;

class GrpcMethod {
    private final String serviceName;
    private final String methodName;
    private final MethodDescriptor.MethodType type;

    static GrpcMethod of(MethodDescriptor<?, ?> methodDescriptor) {
        String string = MethodDescriptor.extractFullServiceName((String)methodDescriptor.getFullMethodName());
        String string2 = methodDescriptor.getFullMethodName().substring(string.length() + 1);
        return new GrpcMethod(string, string2, methodDescriptor.getType());
    }

    private GrpcMethod(String string, String string2, MethodDescriptor.MethodType methodType) {
        this.serviceName = string;
        this.methodName = string2;
        this.type = methodType;
    }

    String serviceName() {
        return this.serviceName;
    }

    String methodName() {
        return this.methodName;
    }

    String type() {
        return this.type.toString();
    }

    boolean streamsRequests() {
        return this.type == MethodDescriptor.MethodType.CLIENT_STREAMING || this.type == MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    boolean streamsResponses() {
        return this.type == MethodDescriptor.MethodType.SERVER_STREAMING || this.type == MethodDescriptor.MethodType.BIDI_STREAMING;
    }
}

